/*
 * Make 3/2018, fls
 * Kurze Demo für Dynamixel-Ansteuerung
 * Library Download: https://sourceforge.net/projects/dynamixelforarduino/files/?source=navbar
 * Servo via 74LS241 angeschlossen
 */

#include <DynamixelSerial.h>

const uint8_t ENABLEPIN = 2;      // Freigabe-Pin
const uint8_t DYNID = 1;          // ID des Servos (default: 1)
uint8_t temperature;

void setup(){}

void loop()
{
  Dynamixel.begin(1000000, ENABLEPIN);      // Initialize the servo at 1Mbps and Pin Control on...
  Dynamixel.ledStatus(DYNID,ON);                    // Servo LED on
  temperature = Dynamixel.readTemperature(DYNID);   // Request the Temperature
  Dynamixel.move(DYNID,random(200,800));            // Move the Servo radomly from 200 to 800
  delay(500);                                       // wait until rotation ends
  Dynamixel.ledStatus(DYNID,OFF);
  Dynamixel.end();                 // End Servo Comunication
  Serial.begin(9600);              // Begin Serial Comunication
  Serial.print("Temperature: ");   // Print the variables in the Serial Monitor
  Serial.println(temperature);
  Serial.end();
  delay(1000);
}
