//==========================================================================================================
//
// Fliptube 7-Segment-Anzeige     CC-by-sa-nc   surasto.de   2018
//
//     __a__
//    |     |
//   f|     |b
//    |     |
//     --g--
//    |     |
//   e|     |c
//    |_____|
//       d
//
//  Dies ist ein einfaches Demonstrationsprogram.
//  Modi:
//    - Start des Arduino ohne USB Anschluss 
//          --> Display Ziffern zählen automatisch hoch
//    - Mit USB und Terminal (z.B. Arduino IDE) 
//          --> 0...9 <enter> setzt das Display auf die entsprechende Ziffer
//          --> A..G <enter> setzt das entsprechende Segment
//          --> a..g <enter> setzt das entsprechende Segment zurück auf Schwarz
//          --> X <enter> Alle Segmente Schwarz
//          --> Z <enter> Automatisch hochzählen
//          --> z <enter> Automatisch hochzählen stoppen
//
//  Erweiterung auf mehrere Ziffern:
//  Zusätzlich zu den Enable pins A0 und A1 weitere Pins definieren z.B.: A1/A2, A3/A4, A5/A6, 12/13
//  Am besten als Paramter an die Funktion write Segment übergeben.
//
//===========================================================================================================

byte digit;
unsigned long initTime;
boolean autoCount;

byte seg[] = {0b11111100,
              0b01100000,
              0b11011010,
              0b11110010,
              0b01100110,
              0b10110110,
              0b10111110,
              0b11100000,
              0b11111110,
              0b11110110,
              0b00000000};

void setup() {
  int i;
  
  // put your setup code here, to run once:
   Serial.begin(9600);
   pinMode(A0,OUTPUT);   // HIGH EN
   pinMode(A1,OUTPUT);   // LOW EN

   pinMode(2,OUTPUT);    // a
   pinMode(3,OUTPUT);    // b
   pinMode(4,OUTPUT);    // c
   pinMode(5,OUTPUT);    // d
   pinMode(6,OUTPUT);    // e
   pinMode(7,OUTPUT);    // f
   pinMode(8,OUTPUT);    // g

   pinMode(9,OUTPUT);     // ERSATZ für d

   digitalWrite(A0,LOW);
   digitalWrite(A1,LOW);      // Both Common disabled
   for (i=2; i<10; i++) digitalWrite(i,LOW);

   resetAll();
   delay(5000);
   digit = 0;

   initTime = millis();
   autoCount = true;
}

void loop() {
  char input;
  
  if (Serial.available()) {        // Test set segments individually
     input = Serial.read();        // A...G set green   a...g set black
                                   // 0...9 digit
                                   // Z count on        z count off
                                   // X clear All
                                   
     if ((input > 64) && (input < 72)) {      // set green
        writeSegment(input-65, 1);
     }   
     if ((input > (64 + 32)) && (input < (72 + 32))) {      // set black
        writeSegment(input-65-32, 0);
     }
     if ((input >= '0') && (input <= '9')) writeDigit(input - '0');
     if (input == 'X') resetAll();
     if (input == 'Z') {
        autoCount = true;
        Serial.println("Autocount ON");
     }
     if (input == 'z') {
        autoCount = false;
        Serial.println("Autocount OFF");
     }
  }

  if (autoCount) { 
    Serial.println(digit); 
    writeDigit(digit++);
    delay(4000);
    if (digit>9) digit=0;
  }
}


void writeDigit(byte digit) {
   int i;
   byte mask;

   mask=128;

   for (i=0; i<7; i++) {
     if (mask & seg[digit]) writeSegment(i, 1);
     else writeSegment(i, 0); 
     mask = mask >> 1;
   }

}


void writeSegment(int segment, int state) {     // segment 0...6  state 0|1
  int i;

  if (state > 0) {
    for (i=2; i<10; i++) digitalWrite(i,LOW);    // Reset all segments
    i = segment + 2;
    delay(10);
    digitalWrite(i, HIGH);
    digitalWrite(A1,HIGH);
    delay(200);
    digitalWrite(A1, LOW);
    digitalWrite(i, LOW);
    delay(50);
  }

  if (state==0) {
    for (i=2; i<10; i++) digitalWrite(i,HIGH);   // Reset all segments
    i = segment + 2;
    delay(10);
    digitalWrite(i, LOW);
    digitalWrite(A0,HIGH);
    delay(200);
    digitalWrite(A0, LOW);
    digitalWrite(i, HIGH);
    delay(50);
  }
}

void resetAll() {
   int i;
  
   for (i=0; i<7; i++) writeSegment(i,0);
   Serial.println("Reset all to black");
}
