set datafile separator "\t"
set terminal svg size 600,800
set output "out.svg"
set title "Temperatur- und Brennerverläufe Heizung"
set y2label "Temperatur"
set y2range [-20:80]
set ytics 0,20,100 nomirror
set ylabel "relative Brennerleistung [%]
set yrange [0:200]
set y2tics 0,10
set xlabel "Zeit [UTC]"
set xdata time
set xrange [time(0)-7200:time(0)]
set timefmt "%s"
set format x "%d.%m.\n%H:%M"
set grid xtics ytics y2tics
set key top left box opaque width -5
plot "datalog.csv" using 1:2 axis x1y2 title "Speicher oben" with lines,\
     "datalog.csv" using 1:3 axis x1y2 title "Speicher unten" with lines,\
     "datalog.csv" using 1:4 axis x1y2 title "Heizungszulauf" with lines,\
     "datalog.csv" using 1:5 axis x1y2 title "Heizkreisvorlauf Soll" with lines,\
     "datalog.csv" using 1:6 axis x1y2 title "Heizkreisvorlauf Ist" with lines,\
     "datalog.csv" using 1:8 axis x1y2 title "Außentemperatur" with lines,\
     "datalog.csv" using 1:7 axis x1y1 title "rel. Brennerleistung" with filledcurve x1
