#!/usr/bin/env python3

import logging

from ev3dev.auto import OUTPUT_B, OUTPUT_C
from ev3dev.webserver import WebControlledTank
#from ev3dev2.auto import OUTPUT_B, OUTPUT_C
#from ev3dev2.webserver import WebControlledTank
from ev3dev2.sound import Sound


class EV3D4WebControlled(WebControlledTank):

    def __init__(self, left_motor=OUTPUT_C, right_motor=OUTPUT_B):
        WebControlledTank.__init__(self, left_motor, right_motor)


sound = Sound()

logging.basicConfig(level=logging.INFO,
                    format='%(asctime)s %(levelname)5s: %(message)s')
log = logging.getLogger(__name__)

log.info('Starting EV3D4')
ev3d4 = EV3D4WebControlled()
sound.play_file('./include/r2d2_sound.wav', 100, 1)

ev3d4.main()  # start the web server
log.info('Exiting EV3D4')
