from machine import Pin, SPI, I2C
from sx127 import SX127x
import network
from mqtt_writer import MQTTWriter
from umqtt.robust import MQTTClient
import json
import time
import utime
import ntptime
from sx127 import SX127x
import ssd1306

# define LoRa Properties
lora_default = {
    'frequency': 869525000,
    'frequency_offset':0,
    'tx_power_level': 14,
    'signal_bandwidth': 125e3,
    'spreading_factor': 9,
    'coding_rate': 5,
    'preamble_length': 8,
    'implicitHeader': False,
    'sync_word': 0x12,
    'enable_CRC': True,
    'invert_IQ': False,
    'debug': False,
}

lora_pins = {
    'dio_0':26,
    'ss':18,
    'reset':16,
    'sck':5,
    'miso':19,
    'mosi':27,
}

lora_spi = SPI(
    baudrate=10000000, polarity=0, phase=0,
    bits=8, firstbit=SPI.MSB,
    sck=Pin(lora_pins['sck'], Pin.OUT, Pin.PULL_DOWN),
    mosi=Pin(lora_pins['mosi'], Pin.OUT, Pin.PULL_UP),
    miso=Pin(lora_pins['miso'], Pin.IN, Pin.PULL_UP),
)

lora = SX127x(lora_spi, pins=lora_pins, parameters=lora_default)

def connect():
  ssid = "WLAN-D48360"
  password =  "6705157510375256"
  station = network.WLAN(network.STA_IF)
  station.active(True)
  station.connect(ssid, password)
  time.sleep(20)
  ntptime.settime()

def connect_mqtt():
  MQTT_HOST= "192.168.2.118"
  USER = "water_level"
  PASSWORD = "water!"
  client = MQTTClient('esp32', MQTT_HOST, 1883, USER, PASSWORD)
  return client
  
def display():
    pin16 = Pin(16, Pin.OUT)
    pin16.value(1)
    i2c = I2C(1, scl=Pin(15), sda=Pin(4), freq = 10000)
    oled = ssd1306.SSD1306_I2C(128, 64, i2c)
    return oled

def receive(lora):
    payload = lora.readPayload().decode()
    return payload
  
def get_time():
    return 946684800 + utime.time()
    
def collect_data():
    water_level = int(receive(lora))
    timestamp = get_time()
    plant = "name"
    return {"level" : water_level, "time" : timestamp, "plant" : plant}

def publish_mqtt():
  data_dict = collect_data()
  data = bytes(json.dumps(data_dict), 'utf-8')
  client = connect_mqtt()
  client.connect()
  client.publish(bytes("water-data", 'utf-8'), data)
  time.sleep(20)
  client.disconnect()	
    
def process():
    oled = display()
    
    while True:
        if lora.receivedPacket():
            oled.text("Received data!", 0, 0)
            oled.show()
            publish_mqtt()
            oled.fill(0)
            oled.show()
