import json
import jsonschema
from jsonschema import validate

class JsonSchemaValidator:
    def __init__(self):
        with open("./data/persons_schema.json", mode="r") as json_schema_input:
            self.json_schema = json.load(json_schema_input)

    def validate_json(self, json_data):
        try:
            validate(instance=json_data, schema=self.json_schema)
        except jsonschema.exceptions.ValidationError as error_message:
            return False, error_message

        return True, ""
