from benedict import benedict
from json_schema_validator import JsonSchemaValidator

def main() -> None:
    # reading data
    json_data = benedict("./data/persons.json")
    print(json_data)

    # validating against JSON schema
    json_schema_validator = JsonSchemaValidator()
    valid_data, error_message = json_schema_validator.validate_json(json_data)

    if not valid_data:
        # Program will terminate if the JSON schema validation failed.
        exit(f"JSON data NOT valid! JSON data cannot be processed! \n {error_message}")

    persons = json_data["persons"]

    aged_33 = []
    grown_ups = []

    for person in persons:
        person_name = f"{person['last_name']}_{person['first_name']}".lower()
        person_street = f'{person["address.street.name"]} {person["address.street.number"]}'
        print(person_street)

        person.to_json(filepath=f"./data/{person_name}.json")

        fit_33 = person.search(33, in_keys=False, in_values=True, exact=False, case_sensitive=False)

        if fit_33:
            aged_33.append(fit_33[0])

        if person['age'] > 20:
            grown_ups.append(person)

        # key available?
        try:
            if person['id'] > 0:
                print('available')
        except KeyError as ke:
            pass


    print(aged_33)
    print(grown_ups)


if __name__ == "__main__":
    main()
