# source:
# https://docs.kanaries.net/pygwalker/use-pygwalker-with-streamlit.en#embedding-pygwalker-in-a-streamlit-application

import pygwalker as pyg
import pandas as pd
import streamlit.components.v1 as components
import streamlit as st
import datetime
def get_dataframe() -> pd.DataFrame:
    """ Creates the dataframe and adjusts it. """
    earthquake_df = pd.read_csv('./data/earthquakes_database.csv', sep=',')

    earthquake_df["Datetime"] = earthquake_df["Date"] + " " + earthquake_df["Time"]
    earthquake_df['Datetime'] = pd.to_datetime(earthquake_df['Datetime'], format='%m/%d/%Y %H:%M:%S')
    earthquake_df['Lat'] = earthquake_df['Latitude'].round(1)
    earthquake_df['Lng'] = earthquake_df['Longitude'].round(1)
    earthquake_df = earthquake_df[["Datetime", 'Latitude', 'Longitude', 'Lat', 'Lng', 'Magnitude', 'Depth']]

    # using only data from 2014 on
    earthquake_df = earthquake_df[earthquake_df['Datetime'] > datetime.datetime(2014, 1, 1)]

    # categorizing earthquakes based on the magnitude
    earthquake_df["Intensity"] = pd.cut(earthquake_df['Magnitude'], bins=[0.0, 4.9, 6.9, 7.9, 12],
                                        labels=['None', 'Easy', 'Medium', 'Heavy'])
    # categorizing earthquakes based on the epi centers' depth
    earthquake_df["DepthCat"] = pd.cut(earthquake_df['Depth'], bins=[0.0, 49.9, 74.9, 99.9, 1000000000],
                                       labels=['low', 'bit deep', 'deep', 'very deep'])

    return earthquake_df

# Adjust the width of the Streamlit page
st.set_page_config(
    page_title="Use Pygwalker In Streamlit",
    layout="wide"
)

# Add Title
st.title("Use Pygwalker In Streamlit")

# Generate the HTML using Pygwalker
pyg_html = pyg.to_html(get_dataframe())

# Embed the HTML into the Streamlit app
components.html(pyg_html, height=1000, scrolling=True)

# ===========================================================================
### new API, but nor working ###

# source:
# https://docs.kanaries.net/pygwalker/use-pygwalker-with-streamlit.en#new-api-for-pygwalker-in-streamlit-recommended

# from pygwalker.api.streamlit import StreamlitRenderer, init_streamlit_comm
# import pandas as pd
# import streamlit as st
# import datetime
#
# # Adjust the width of the Streamlit page
# st.set_page_config(
#     page_title="Use Pygwalker In Streamlit",
#     layout="wide"
# )
#
# # Establish communication between pygwalker and streamlit
# init_streamlit_comm()
#
# # Add a title
# st.title("Use Pygwalker In Streamlit")
#
#
# def get_dataframe() -> pd.DataFrame:
#     earthquake_df = pd.read_csv('./data/earthquakes_database.csv', sep=',')
#
#     earthquake_df["Datetime"] = earthquake_df["Date"] + " " + earthquake_df["Time"]
#     earthquake_df['Datetime'] = pd.to_datetime(earthquake_df['Datetime'], format='%m/%d/%Y %H:%M:%S')
#     earthquake_df['Lat'] = earthquake_df['Latitude'].round(1)
#     earthquake_df['Lng'] = earthquake_df['Longitude'].round(1)
#     earthquake_df = earthquake_df[["Datetime", 'Latitude', 'Longitude', 'Lat', 'Lng', 'Magnitude', 'Depth']]
#
#     # using only data from 2014 on
# #     earthquake_df = earthquake_df[earthquake_df['Datetime'] > datetime.datetime(2014, 1, 1)]
#
#     # categorizing earthquakes based on the magnitude
#     earthquake_df["Intensity"] = pd.cut(earthquake_df['Magnitude'], bins=[0.0, 4.9, 6.9, 7.9, 12],
#                                         labels=['None', 'Easy', 'Medium', 'Heavy'])
#     # categorizing earthquakes based on the epi centers' depth
#     earthquake_df["DepthCat"] = pd.cut(earthquake_df['Depth'], bins=[0.0, 49.9, 74.9, 99.9, 1000000000],
#                                        labels=['low', 'bit deep', 'deep', 'very deep'])
#
#     return earthquake_df
#
# # Get an instance of pygwalker's renderer. You should cache this instance to effectively prevent the growth of in-process memory.
# @st.cache_resource
# def get_pyg_renderer() -> StreamlitRenderer:
#     # When you need to publish your app to the public, you should set the debug parameter to False to prevent other users from writing to your chart configuration file.
#     return StreamlitRenderer(
#         get_dataframe(),
#         spec="./gw_config.json",
#         use_kernel_calc=True,
#         debug=False
#     )
#
#
# renderer = get_pyg_renderer()
#
# # Render your data exploration interface. Developers can use it to build charts by drag and drop.
# renderer.render_explore()
