;;; ChaiNT - Chain Loader fuer den NT Bootmanager (und andere).
;;; Copyright (c) 1997 Michael Riepe <michael@stud.uni-hannover.de>
;;
;; Dieses Programm ist Freie Software im Sinne der GNU General Public
;; License (GPL), Version 2 (siehe Datei COPYING).

;;; Chaining-Parameter: Laufwerk, Partition, ...

%ifndef DRIVE
%define DRIVE		0x80
%endif
%ifndef PARTNO
%define PARTNO		0
%endif
%ifndef PARTTYPE
%define PARTTYPE	0
%endif
%ifndef MAKEACTIVE
%define MAKEACTIVE	0
%endif

;;; Diverse Konstanten...

TABLE_OFFSET	equ 0x1be
SIG_OFFSET	equ 0x1fe

SIGNATURE	equ 0xaa55

;;; ... und Adressen

part_sector	equ 0x600
part_table	equ part_sector + TABLE_OFFSET
part_sig	equ part_sector + SIG_OFFSET

boot_sector	equ 0x7c00
boot_sig	equ boot_sector + SIG_OFFSET

	SECTION .text

	ORG 0x800	;; ChaiNT-Ladeadresse

;;; Programmstart

	GLOBAL _main
_main:
	jmp short start

	times 4-($-$$) db 0

;;; Parameter-Block

bios_drv:
	db DRIVE
part_no:
	db PARTNO
part_type:
	db PARTTYPE
make_active:
	db MAKEACTIVE

version:
	db "ChaiNT v1.0",13,10
	db "Copyright (c) 1997 Michael Riepe",13,10
	db 0

;;; Kopiere ChaiNT an den richtigen Platz

start:
	cli 
	xor ax,ax
	mov ss,ax
	mov sp,boot_sector
	mov es,ax
	mov ds,ax
	sti 
	mov si,sp		; von 0:7C00
	mov di,_main		; nach 0:0800
	mov cx,0x100
	cld 
	rep movsw 
	jmp 0:load_mbr

;;; Lade den MBR

load_mbr:
	mov ax,0x201
	mov bx,part_sector
	mov cx,1
	xor dh,dh
	mov dl,[bios_drv]
	int 0x13
	jc mbr_fail
	cmp word [part_sig],SIGNATURE
	jnz mbr_fail

;;; Suche Partition

	mov si,part_table
	mov al,[part_type]
	or al,al
	jz fixed_part

;;; Suche Partition mit passendem Typ

search_part:
	cmp byte [si+4],al
	jz found_part
	add si,byte 0x10
	cmp si,part_sig
	jb search_part
	jmp short mbr_fail

;;; Suche Partition Nummer <PARTNO>

fixed_part:
	mov al,[part_no]
	and ax,3
	shl ax,4
	add si,ax
	cmp byte [si+4],0
	jz no_such_part

;;; Partition gefunden, lade und starte Bootsektor

found_part:
	mov bp,si
	mov dx,[si]
	mov cx,[si+2]
	mov dl,[bios_drv]
	mov bx,boot_sector
	mov ax,0x201
	int 0x13
	jc bread_fail
	cmp word [boot_sig],SIGNATURE
	jnz boot_fail
	mov si,bp
	cmp byte [make_active],0
	jz bsecrun
	call install_int13	; Installiere Umleitung fuer INT 0x13
bsecrun:
	jmp 0:boot_sector	; Starte Bootsektor

;;; Diverse Fehlermeldungen

mbr_fail:
	call error
	db "Kann Partition nicht finden.",0

no_such_part:
	call error
	db "Partition existiert nicht.",0

bread_fail:
	call error
	db "Kann Bootsektor nicht lesen.",0

boot_fail:
	call error
	db "Bootsektor ist fehlerhaft.",0

;;; Gib String aus und halte an

prc:
	push si
	mov bx,7
	mov ah,0x0e
	int 0x10
error:
	pop si
	lodsb 
	or al,al
	jnz prc
die:
	jmp short die

;;; Code fuer INT 0x13 (wird ans Ende des unteren RAM-Bereichs kopiert)

poffset:			; Der zu kopierende Bereich beginnt hier
	dw 0

notmbr:
	db 0xea			; Sprung zum Original-Handler
int13:
	dw 0,0

int13_new:
	cmp ah,0x2		; Lesezugriff?
	jnz notmbr
	cmp cx,byte 1		; Spur 0, Sektor 1?
	jnz notmbr
	cmp dx,0x80		; Kopf 0, Laufwerk C:?
	jnz notmbr
	pusha
	mov bp,sp
	or byte [bp+20],0x01	; Setze Carry-Flag
	pushf
	call far [cs:int13-poffset]
	jc int13fail
	and byte [bp+20],0xfe	; Loesche Carry-Flag
	mov byte [es:bx+0x1be],0	; Modifiziere gelesenen MBR
	mov byte [es:bx+0x1ce],0
	mov byte [es:bx+0x1de],0
	mov byte [es:bx+0x1ee],0
	add bx,[cs:poffset-poffset]
	mov byte [es:bx],0x80	; Aktiviere ausgewaehlte Partition
int13fail:
	mov [bp+14],ax		; Fehlercode fuer INT 0x13
	popa
	iret
pend:				; Der zu kopierende Bereich endet hier

;;; Installiere Code fuer INT 0x13

install_int13:
	pusha
	sub si,part_sector
	mov [poffset],si	; Speichere Offset des gewaehlten Eintrags
	mov ax,[0x413]
	dec ax
	mov [0x413],ax		; Zwacke 1 KByte RAM ab
	shl ax,6
	mov es,ax
	mov si,poffset
	xor di,di
	mov cx,pend-poffset
	cld
	rep movsb		; Kopiere Interrupt-Routine dorthin
	cli
	xchg [0x4e],ax		; Aendere Interrupt-Vektor
	mov [es:int13-poffset+2],ax
	mov ax,int13_new-poffset
	xchg [0x4c],ax
	mov [es:int13-poffset],ax
	sti
	popa
	ret

;;; Fuellbytes

	times SIG_OFFSET-($-$$) db 0

;;; Bootsektor-Signatur

signature:
	dw SIGNATURE

;;; Ende
