package net.nieden.FileCrypter;

import java.io.*;
import java.util.*;
import javax.crypto.*;

public class CFileDecrypter {
	private IFileProgressIndicator pgrsIndicator=null;
	private Cipher dcipher;
	private FileInputStream fis;
	private CFileHeader cfHeader;
	private String passwd;
	
	public CFileDecrypter(File f, String passwd) throws Exception {
		dcipher=CFileTools.initDecryption(this.passwd=passwd);
		/**
		 * read file header 1st
		 */
		
		fis=new FileInputStream(f);
		cfHeader=new CFileHeader(fis, dcipher, passwd);
	}
	
	public void processFile() throws Exception {
		processFile(false);
	}

	public void processFile(boolean multiThreaded) throws Exception {
		CFileBlockProcessor blockProc=null;
		File fTemp=new File(String.format("DECRY_%012x.bin",new Date().getTime()));
		FileOutputStream fos=new FileOutputStream(fTemp);
		if (multiThreaded)
			blockProc=new CFileBlockProcessor(cfHeader.blockCount, false, pgrsIndicator);
		for (int i=0;i<cfHeader.blockCount;i++) {
			int bsize;
			for (int j=bsize=0;j<4;j++) {
				int ch=fis.read()&0xff;
				bsize|= ch << ((3-j)*8);
			}
			byte[] iBlock=CFileTools.readFromInputStream(fis, bsize);
			/* System.out.printf("Block %d: %d bytes: %02x %02x %02x %02x ...\n",
				i+1, bsize,iBlock[0]&0xff,iBlock[1]&0xff,iBlock[2]&0xff,iBlock[3]&0xff);
			System.out.flush(); */
			if (multiThreaded) {
				for (;;) {
					// wait for free thread ...
					int count=blockProc.getWorkingThreadCount();
					if (count < blockProc.maxThreads) {
						blockProc.blockProcThreadList.get(i).startWorking(iBlock, cfHeader.compression, passwd, fos);
						break;
					}
					Thread.sleep(100);
				}
			} else {
				byte[] oBlock=CFileTools.decryptBlock(dcipher, iBlock);
				if (cfHeader.compression) {
					byte[] ob=CFileTools.decompressBlock(oBlock);
					oBlock=ob;
				}
				fos.write(oBlock, 0, oBlock.length);
				if (pgrsIndicator!=null)
					pgrsIndicator.progressIndicator(i, cfHeader.blockCount);
			}
		}
		fis.close();
		if (multiThreaded) {
			// wait for last block to finish
			blockProc.waitForLastBlock();
		}
		fos.close();
		File fOut=new File(cfHeader.originalFileName);
		if (fOut.exists()) {
			
		} else fTemp.renameTo(fOut);
	}

	public void setProgressIndicator(IFileProgressIndicator prgsIndicator) {
		this.pgrsIndicator=prgsIndicator;
	}
}
