/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.eclipse.core.proxy;

import com.google.appengine.eclipse.core.AppEngineCorePlugin;
import com.google.appengine.eclipse.core.AppEngineCorePluginLog;
import com.google.appengine.eclipse.core.sdk.AppEngineBridge;
import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.info.Version;
import com.google.apphosting.runtime.security.WhiteList;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.sdk.SdkUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppEngineBridgeImpl
implements AppEngineBridge {
    private static final IPath APPENGINE_TOOLS_API_JAR_PATH = new Path("lib/appengine-tools-api.jar");
    private static final VersionComparator VERSION_COMPARATOR = new VersionComparator();
    private static final String MIN_SUPPORTED_VERSION = "0.0.0";

    private static AppAdmin createAppAdmin(final AppEngineBridge.DeployOptions options) throws IOException {
        AppAdminFactory appAdminFactory = new AppAdminFactory();
        if (options.getJavaExecutableOSPath() != null) {
            appAdminFactory.setJavaExecutable(new File(options.getJavaExecutableOSPath()));
        }
        if (options.getJavaCompilerExecutableOSPath() != null) {
            appAdminFactory.setJavaCompiler(new File(options.getJavaCompilerExecutableOSPath()));
        }
        Application app = Application.readApplication((String)options.getDeployFolderOSPath());
        PrintWriter errorWriter = new PrintWriter(options.getErrorStream(), true);
        AppAdminFactory.ConnectOptions appEngineConnectOptions = new AppAdminFactory.ConnectOptions();
        appEngineConnectOptions.setUserId(options.getEmail());
        appEngineConnectOptions.setPasswordPrompt(new AppAdminFactory.PasswordPrompt(){

            public String getPassword() {
                return options.getPassword();
            }
        });
        String appengineServer = System.getenv("APPENGINE_SERVER");
        if (appengineServer != null) {
            appEngineConnectOptions.setServer(appengineServer);
        }
        AppAdmin appAdmin = appAdminFactory.createAppAdmin(appEngineConnectOptions, app, errorWriter);
        return appAdmin;
    }

    private static void getLibs(File dir, List<File> list) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                AppEngineBridgeImpl.getLibs(f, list);
            } else if (f.getName().endsWith(".jar")) {
                list.add(f);
            }
            ++n2;
        }
    }

    public AppEngineBridgeImpl() throws CoreException {
        if (!this.hasSdkInfo() || !this.isCompatibleVersion()) {
            throw new CoreException(StatusUtilities.newErrorStatus((String)"App Engine SDK version must be greater than 0.0.0 in order to work with this plugin.", (String)AppEngineCorePlugin.PLUGIN_ID));
        }
    }

    public IStatus deploy(IProgressMonitor monitor, AppEngineBridge.DeployOptions options) throws IOException {
        UpdateCheck updateCheck = new UpdateCheck(SdkInfo.getDefaultServer());
        if (updateCheck.allowedToCheckForUpdates()) {
            updateCheck.maybePrintNagScreen(new PrintStream(options.getOutputStream(), true));
        }
        AppAdmin appAdmin = null;
        appAdmin = AppEngineBridgeImpl.createAppAdmin(options);
        DeployUpdateListener deployUpdateListener = new DeployUpdateListener(monitor, new PrintWriter(options.getOutputStream(), true), new PrintWriter(options.getErrorStream(), true));
        try {
            appAdmin.update((UpdateListener)deployUpdateListener);
            return deployUpdateListener.getStatus();
        }
        catch (AdminException e) {
            return new Status(4, AppEngineCorePlugin.PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getAppId(IPath warPath) throws IOException {
        Application app = Application.readApplication((String)warPath.toOSString());
        return app.getAppId();
    }

    public String getAppVersion(IPath warPath) throws IOException {
        Application app = Application.readApplication((String)warPath.toOSString());
        return app.getVersion();
    }

    public List<File> getBuildclasspathFiles() {
        ArrayList<File> classpathFiles = new ArrayList<File>();
        classpathFiles.addAll(this.getSharedLibFiles());
        classpathFiles.addAll(this.getUserLibFiles());
        classpathFiles.add(new Path(SdkInfo.getSdkRoot().getAbsolutePath()).append(APPENGINE_TOOLS_API_JAR_PATH).toFile());
        return classpathFiles;
    }

    public String getSdkVersion() {
        return SdkInfo.getLocalVersion().getRelease();
    }

    public List<File> getSharedLibFiles() {
        return SdkInfo.getSharedLibFiles();
    }

    public List<File> getToolsLibFiles() {
        ArrayList<File> toolLibFiles = new ArrayList<File>();
        AppEngineBridgeImpl.getLibs(new File(SdkInfo.getSdkRoot(), "lib" + File.separator + "tools"), toolLibFiles);
        return toolLibFiles;
    }

    public List<File> getUserLibFiles() {
        return SdkInfo.getUserLibFiles();
    }

    public Set<String> getWhiteList() {
        return WhiteList.getWhiteList();
    }

    private boolean hasSdkInfo() {
        try {
            Class.forName("com.google.appengine.tools.info.SdkInfo", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private boolean isCompatibleVersion() {
        Version sdkVersion = SdkInfo.getLocalVersion();
        return VERSION_COMPARATOR.compare(sdkVersion.getRelease(), MIN_SUPPORTED_VERSION) >= 0;
    }

    private static final class DeployUpdateListener
    implements UpdateListener {
        private final IProgressMonitor monitor;
        private IStatus status = Status.OK_STATUS;
        private int percentDone = 0;
        private final PrintWriter outputWriter;
        private final PrintWriter errorWriter;

        private static String getDetailsIfSupported(Object updateEvent) {
            try {
                Method method = updateEvent.getClass().getDeclaredMethod("getDetails", new Class[0]);
                return (String)method.invoke(updateEvent, new Object[0]);
            }
            catch (SecurityException e) {
                AppEngineCorePluginLog.logError((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                AppEngineCorePluginLog.logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                AppEngineCorePluginLog.logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                AppEngineCorePluginLog.logError((Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            return null;
        }

        private static boolean isJspCompilationException(Throwable ex) {
            if (ex != null) {
                try {
                    Class<?> jspCompilationExceptionClass = Class.forName("com.google.appengine.tools.admin.JspCompilationException");
                    return jspCompilationExceptionClass.isAssignableFrom(ex.getClass());
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return false;
        }

        private DeployUpdateListener(IProgressMonitor monitor, PrintWriter outputWriter, PrintWriter errorWriter) {
            this.monitor = monitor;
            this.outputWriter = outputWriter;
            this.errorWriter = errorWriter;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void onFailure(UpdateFailureEvent event) {
            String details;
            this.monitor.done();
            this.status = new Status(4, AppEngineCorePlugin.PLUGIN_ID, event.getFailureMessage(), event.getCause());
            this.outputWriter.println(event.getFailureMessage());
            if (DeployUpdateListener.isJspCompilationException(event.getCause()) && (details = DeployUpdateListener.getDetailsIfSupported(event)) != null) {
                this.outputWriter.println(details);
            }
        }

        public void onProgress(UpdateProgressEvent event) {
            int worked = event.getPercentageComplete() - this.percentDone;
            this.percentDone += worked;
            this.monitor.worked(worked);
            this.monitor.setTaskName(event.getMessage());
            this.outputWriter.println(event.getMessage());
            if (this.monitor.isCanceled()) {
                event.cancel();
                this.status = new Status(8, AppEngineCorePlugin.PLUGIN_ID, "User cancelled");
                this.outputWriter.println(this.status.getMessage());
            }
        }

        public void onSuccess(UpdateSuccessEvent event) {
            this.monitor.done();
            String details = DeployUpdateListener.getDetailsIfSupported(event);
            if (details != null) {
                this.errorWriter.println(details);
            }
            this.outputWriter.println("Deployment completed successfully");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VersionComparator
    implements Comparator<String> {
        private VersionComparator() {
        }

        @Override
        public int compare(String version1, String version2) throws NumberFormatException {
            return SdkUtils.compareVersionStrings((String)version1, (String)version2);
        }
    }
}

