/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.x509;

import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509Certificate
extends SignatureElementProxy
implements XMLX509DataContent {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$keys$content$x509$XMLX509Certificate == null ? (class$org$apache$xml$security$keys$content$x509$XMLX509Certificate = XMLX509Certificate.class$("org.apache.xml.security.keys.content.x509.XMLX509Certificate")) : class$org$apache$xml$security$keys$content$x509$XMLX509Certificate).getName());
    public static final String JCA_CERT_ID = "X.509";
    static /* synthetic */ Class class$org$apache$xml$security$keys$content$x509$XMLX509Certificate;

    public XMLX509Certificate(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public XMLX509Certificate(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public XMLX509Certificate(Document document, X509Certificate x509Certificate) throws XMLSecurityException {
        super(document);
        try {
            this.addBase64Text(x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new XMLSecurityException("empty", certificateEncodingException);
        }
    }

    public byte[] getCertificateBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public X509Certificate getX509Certificate() throws XMLSecurityException {
        try {
            byte[] byArray = this.getCertificateBytes();
            CertificateFactory certificateFactory = CertificateFactory.getInstance(JCA_CERT_ID);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            if (x509Certificate != null) {
                return x509Certificate;
            }
            return null;
        }
        catch (CertificateException certificateException) {
            throw new XMLSecurityException("empty", certificateException);
        }
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        X509Certificate x509Certificate = this.getX509Certificate();
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public boolean equals(Object object) {
        try {
            if (!object.getClass().getName().equals(this.getClass().getName())) {
                return false;
            }
            XMLX509Certificate xMLX509Certificate = (XMLX509Certificate)object;
            return JavaUtils.binaryCompare(xMLX509Certificate.getCertificateBytes(), this.getCertificateBytes());
        }
        catch (XMLSecurityException xMLSecurityException) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509Certificate";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

