/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TransformEnvelopedSignature
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            Object object;
            Document document;
            Element element;
            Node node;
            Set set = xMLSignatureInput.getNodeSet();
            if (set.isEmpty()) {
                Object[] objectArray = new Object[]{"input node set contains no nodes"};
                throw new TransformationException("generic.EmptyMessage", objectArray);
            }
            boolean bl = false;
            for (node = element = this._transformObject.getElement(); node != null && node.getNodeType() != 9; node = node.getParentNode()) {
                if (!node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || !node.getLocalName().equals("Signature")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new TransformationException("envelopedSignatureTransformNotInSignatureElement");
            }
            Document document2 = element.getOwnerDocument();
            if (document2 != (document = XMLUtils.getOwnerDocument((Node)set.iterator().next()))) {
                throw new TransformationException("xpath.funcHere.documentsDiffer");
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (Node)iterator.next();
                if (TransformEnvelopedSignature.isDescendantOrSelf(node, (Node)object)) continue;
                hashSet.add(object);
            }
            object = new XMLSignatureInput(hashSet, xMLSignatureInput.getCachedXPathAPI());
            return object;
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException("empty", sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException("empty", parserConfigurationException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
    }

    static boolean isDescendantOrSelf(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        Node node3 = node2;
        while (node3 != null) {
            if (node3 == node) {
                return true;
            }
            if (node3.getNodeType() == 2) {
                node3 = ((Attr)node3).getOwnerElement();
                continue;
            }
            node3 = node3.getParentNode();
        }
        return false;
    }
}

