/**
 * Copyright [2013] Markus Eisele
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package appletdemo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JLabel;

/**
 * Simple Applet-Demo for heise.de/developer
 *
 * @author eiselem
 */
public class AppletDemo extends JApplet {

    @Override
    public void init() {
        //Execute a job on the event-dispatching thread:
        //creating this applet's GUI.
        try {
            javax.swing.SwingUtilities.invokeAndWait(new Runnable() {
                @Override
                public void run() {
                    boolean created = false;
                    /**
                     * Path target = Paths.get("D:\\temp\\test.txt"); try { Path
                     * file = Files.createFile(target); created = true; } catch
                     * (IOException ex) { System.err.println("Creating file
                     * failed"); ex.printStackTrace(System.err); }
                     */
                    createGUI(created);
                }
            });
        } catch (InterruptedException | InvocationTargetException e) {
            System.err.println("createGUI didn't successfully complete");
            e.printStackTrace(System.err);
        }
    }

    private void createGUI(boolean created) {
        String text = "You are successfully running a Swing applet!";
        if (created) {
            text += "File was created: " + created;
        }
        createGUI(text);
    }

    private void createGUI(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(JLabel.CENTER);
        label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
        getContentPane().add(label, BorderLayout.CENTER);
    }
}
