package de.ix.developer.view;

import com.thoughtworks.selenium.DefaultSelenium;
import de.ix.developer.HelloBean;
import java.io.File;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(Arquillian.class)
public class UserTest {

    private static final String WEBAPP_SRC = "src/main/webapp";

    @Deployment(testable = false)
    public static WebArchive createDeployment() {
        return ShrinkWrap.create(WebArchive.class, "user.war").addClasses(HelloBean.class, UserController.class).addAsWebResource(new File(WEBAPP_SRC, "login.xhtml")).addAsWebResource(new File(WEBAPP_SRC, "home.xhtml")).addAsWebInfResource(EmptyAsset.INSTANCE, "beans.xml").addAsWebInfResource(EmptyAsset.INSTANCE, "faces-config.xml");
    }
    @Drone
    DefaultSelenium browser;
    @ArquillianResource
    URL deploymentURL;

    @Test
    public void should_login_successfully() {
        browser.open(deploymentURL + "login.jsf");
        browser.type("id=loginForm:username", "Developer");
        browser.click("id=loginForm:login");
        browser.waitForPageToLoad("15000");
        browser.captureScreenshot("target/screenshot.png");
        Assert.assertTrue("User should be logged in!",
                browser.isElementPresent("xpath=//li[contains(text(), 'Hallo Developer!')]"));
    }
}
