#include <boost/mpl/vector.hpp>
#include <boost/mpl/sort.hpp>
#include <boost/mpl/equal.hpp>
#include <boost/mpl/equal_to.hpp>
#include <boost/mpl/size_t.hpp>

using namespace boost;
using namespace boost::mpl;

typedef mpl::vector<char,int,short> vec;

template <typename T>
struct sizeof_
  : mpl::size_t<sizeof(T)> {};

template <typename T, typename S>
struct less_size
    : mpl::less< sizeof_<T>, sizeof_<S> > {};

typedef mpl::sort< vec, less_size<_,_> >::type sorted;
BOOST_MPL_ASSERT((
  equal< sorted, vector<char,short,int> >
));
