#include "variant2qvariant.h"

#include <QRect>
#include <QString>

#include <iostream>
#include <cstdlib>
#include <cassert>

// needed when variant2qvariant.h uses variant2qvariant_visitor
// instead of variant2qvariant_visitor_with_string_conversion:
//Q_DECLARE_METATYPE( std::string )

typedef boost::variant<int,QPoint,QRect,std::string> Variant;

int main() {

    const Variant v1 = 12;
    const Variant v2 = QPoint( 1, 2 );
    const Variant v3 = QRect( 1, 2, 3, 4 );
    const Variant v4 = std::string("Hello");

    const QVariant qv1 = variant2qvariant( v1 );
    const QVariant qv2 = variant2qvariant( v2 );
    const QVariant qv3 = variant2qvariant( v3 );
    const QVariant qv4 = variant2qvariant( v4 );

    assert( qv1.type() == QVariant::Int );
    assert( qv1.toInt() == 12 );

    assert( qv2.type() == QVariant::Point );
    assert( qv2.toPoint() == QPoint( 1, 2 ) );

    assert( qv3.type() == QVariant::Rect );
    assert( qv3.toRect() == QRect( 1, 2, 3, 4 ) );

    assert( qv4.type() == QVariant::String );
    assert( qv4.toString() == QLatin1String("Hello") );

    std::cerr << "OK" << std::endl;
    return EXIT_SUCCESS;
}
