#ifndef QVARIANT2VARIANT_H__
#define QVARIANT2VARIANT_H__

#include <QVariant>
#include <boost/variant.hpp>

#include <boost/mpl/pop_front.hpp>
#include <boost/mpl/front.hpp>
#include <boost/mpl/empty.hpp>

struct bad_cast {};

template <typename T_Variant, typename Types>
typename boost::enable_if< boost::mpl::empty<Types>, T_Variant >::type
qvariant2variant_helper( const QVariant & ) {
  throw bad_cast();
}

template <typename T_Variant, typename Types>
typename boost::disable_if< boost::mpl::empty<Types>, T_Variant >::type
qvariant2variant_helper( const QVariant & qv ) {
  // split Types into Head and Tail:
  typedef typename boost::mpl::front<Types>::type Head;
  typedef typename boost::mpl::pop_front<Types>::type Tail;
  // the static_cast is there to fix a signed/unsigned warning
  if ( static_cast<int>( qv.type() ) == qMetaTypeId<Head>() )
    return T_Variant( qvariant_cast<Head>( qv ) );
  else
    return qvariant2variant_helper<T_Variant,Tail>( qv );
}

template <typename T_Variant>
T_Variant qvariant2variant( const QVariant & qv ) {
  return qvariant2variant_helper<T_Variant,typename T_Variant::types>( qv );
}


#endif /* QVARIANT2VARIANT_H__ */
