﻿using System;
using System.IO;

namespace WWWings_DZS
{
 /// <summary>
 /// Erweiterung der Kontextklasse
 /// </summary>
 public partial class WWWingsModellContainer
 {
  public static string Protokolldatei;
  static WWWingsModellContainer()
  {
    Protokolldatei = Path.Combine(Path.GetTempPath(), "EFLog.txt");
  }
  /// <summary>
  /// Überschreiben von SaveChanges: Zusätzliches Protokollieren in Datei
  /// </summary>
  public override int SaveChanges(System.Data.Objects.SaveOptions options)
  {
   // Alle Ändeurngen aus den Objekten sammeln
   this.DetectChanges();

   // Hole Geänderte
   foreach (var ose in this.ObjectStateManager.GetObjectStateEntries(System.Data.EntityState.Modified))
   {
    foreach (var mprop in ose.GetModifiedProperties())
    {
     WriteProtokoll(ose.EntitySet.Name, (int)ose.EntityKey.EntityKeyValues[0].Value, "Modified", mprop, ose.OriginalValues[mprop].ToString(), ose.CurrentValues[mprop].ToString(), "");
    }
   }

   // Hole Neue
   foreach (var ose in this.ObjectStateManager.GetObjectStateEntries(System.Data.EntityState.Added))
   {
    // Um den Primärschlüssel für neue Objekte mit AutoWert zu ermitteln ist etwas mehr Aufwand notwendig; wird hier aber vermieden, um Komplexität nicht zu steigern
    int Key = -1;
    if (ose.EntityKey != null && ose.EntityKey.EntityKeyValues!= null && ose.EntityKey.EntityKeyValues[0] != null) Key = (int)ose.EntityKey.EntityKeyValues[0].Value;

    WriteProtokoll(ose.EntitySet.Name, Key, "Added", "", "", "", "");
   }

   // Hole Gelöschte
   foreach (var ose in this.ObjectStateManager.GetObjectStateEntries(System.Data.EntityState.Deleted))
   {
    WriteProtokoll(ose.EntitySet.Name, (int)ose.EntityKey.EntityKeyValues[0].Value, "Deleted", "", "", "", "");
   }

   // Nun Standardimplementierung aufrufen
   int Anzahl = base.SaveChanges(options);
   return Anzahl;
  }

  /// <summary>
  /// Erzeuge Protokolleintrag
  /// </summary>
  public void WriteProtokoll(string Entity, int EntityID, string Aktion, string Attribut, string AlterWert, string NeuerWert, string Text)
  {
   System.IO.StreamWriter sw = new System.IO.StreamWriter(WWWingsModellContainer.Protokolldatei, true);

   sw.WriteLine(DateTime.Now + ";" + Entity + ";" + EntityID + ";" + Aktion + ";" + Attribut + ";" + AlterWert + ";" + NeuerWert + ";" + Text);
   sw.Close();
  }

 }
}
