﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WWWings_GO;

namespace WWWings_DZS
{

 /// <summary>
 /// Datenmanager für Passagiere
 /// </summary>
 public class PassagierDataManager : IDisposable
 {

  // Eine Instanz des Datenkontextes pro Manager-Instanz
  WWWingsModellContainer modell = new WWWingsModellContainer();

  public PassagierDataManager(bool LazyLoading = false)
  {
   modell.ContextOptions.LazyLoadingEnabled = LazyLoading;
  }

  /// <summary>
  /// Holt einen Passagier
  /// </summary>
  public Passagier GetPassagier(int PassagierID)
  {
   // .OfType<Passagier>() notwendig wegen Vererbung
   var abfrage = from p in modell.PersonSet.OfType<Passagier>() where p.ID == PassagierID select p;
   return abfrage.SingleOrDefault();
  }

  /// <summary>
  /// Holt alle Passagiere mit einem Namen
  /// </summary>
  public List<Passagier> GetPassagiere(string Name)
  {
   // .OfType<Passagier>() notwendig wegen Vererbung
   var abfrage = from p in modell.PersonSet.OfType<Passagier>() where p.Name == Name select p;
   return abfrage.ToList();
  }

  /// <summary>
  /// Füge einen Passagier zu einem Flug hinzu
  /// </summary>
  public bool AddPassagierZuFlug(int PassagierID, int FlugID)
  {
   try
   {
    Flug flug = modell.FlugSet.Where(f => f.ID == FlugID).SingleOrDefault();
    Passagier passagier = modell.PersonSet.OfType<Passagier>().Where(p => p.ID == PassagierID).SingleOrDefault();
    flug.Passagier.Add(passagier);

    modell.SaveChanges();
    return true;
   }
   catch (Exception ex)
   {
    return false;
   }
  }

  /// <summary>
  /// Änderungen an einer Liste von Passagieren speichern
  /// </summary>
  public string SavePassagierSet(List<Passagier> PassagierSet)
  {

   // Änderungen für jeden einzelnen Passagier übernehmen
   foreach (Passagier p in PassagierSet)
   {
    modell.PersonSet.ApplyChanges(p);
   }

   // Statistik der Änderungen zusammenstellen
   string Rueckgabe = "";
   Rueckgabe += "Geändert: " + modell.ObjectStateManager.GetObjectStateEntries(System.Data.EntityState.Modified).Count();
   Rueckgabe += " Neu: " + modell.ObjectStateManager.GetObjectStateEntries(System.Data.EntityState.Added).Count();
   Rueckgabe += " Gelöscht: " + modell.ObjectStateManager.GetObjectStateEntries(System.Data.EntityState.Deleted).Count();

   // Änderungen speichern
   modell.SaveChanges();

   // Statistik der Änderungen zurückgeben
   return Rueckgabe;
  }


  public void Dispose()
  {
   modell.Dispose();
  }
 }
}
