﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.IO.IsolatedStorage;
using System.IO;

namespace WP7Storage1
{
    public partial class MainPage : PhoneApplicationPage
    {
        IsolatedStorageFile myISFile;

        // Constructor
        public MainPage()
        {
            InitializeComponent();
            myISFile = IsolatedStorageFile.GetUserStoreForApplication();
        }

        private void CmdRead_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                IsolatedStorageFileStream myStream = new IsolatedStorageFileStream("settings.tmgn", System.IO.FileMode.Open, myISFile);
                StreamReader reader = new StreamReader(myStream);
                textBox1.Text = reader.ReadToEnd();
                reader.Close();

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void CmdStor_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                //Create == Create OR Overwrite
                IsolatedStorageFileStream myStream = new IsolatedStorageFileStream("settings.tmgn", System.IO.FileMode.Create, myISFile);
                StreamWriter writer = new StreamWriter(myStream);
                writer.Write(textBox1.Text);
                writer.Close();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void CmdDel_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                myISFile.DeleteFile("settings.tmgn");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
    }
}