#include "Form1.h"
#include "HeiseBada1.h"

using namespace Osp::Base;
using namespace Osp::Ui;
using namespace Osp::Ui::Controls;

Form1::Form1(void)
{
}

Form1::~Form1(void)
{
}

bool
Form1::Initialize()
{
	// Construct an XML form
	Construct(L"IDF_FORM1");

	return true;
}

result
Form1::OnInitializing(void)
{
	result r = E_SUCCESS;

	GetFooter()->AddActionEventListener(*this);

	myKillFlag=false;
	myList = static_cast<ListView *>(GetControl(L"IDC_LISTVIEW1"));
	myList->SetItemProvider(*this);
	myList->AddListViewItemEventListener(*this);

	return r;
}

result
Form1::OnTerminating(void)
{
	result r = E_SUCCESS;

	// TODO: Add your termination code here

	return r;
}

void
Form1::OnActionPerformed(const Osp::Ui::Control& source, int actionId)
{
	switch(actionId)
	{
	case ID_FOOTER_ADD:
		{//Compiler whines re reuse
			HeiseBada1 *anApp;
			anApp=static_cast<HeiseBada1*>(Osp::App::Application::GetInstance());
			Frame *pFrame;
			pFrame = anApp->GetAppFrame()->GetFrame();
			pFrame->SetCurrentForm(*(anApp->pEditForm));
			anApp->pEditForm->SetIDAndMode(true,0, this);
			anApp->pEditForm->RequestRedraw(true);
		}
	case ID_FOOTER_EDIT:
	{
		bool isFormulaFound=false;
		int i;
		for(i=0;i<myList->GetItemCount();i++)
		{
			if(myList->IsItemChecked(i))
			{
				isFormulaFound=true;
				break;
			}
		}
		if(isFormulaFound)
		{
			HeiseBada1 *anApp;
			anApp=static_cast<HeiseBada1*>(Osp::App::Application::GetInstance());
			Frame *pFrame;
			pFrame = anApp->GetAppFrame()->GetFrame();
			pFrame->SetCurrentForm(*(anApp->pEditForm));
			anApp->pEditForm->SetIDAndMode(false,i, this);
			anApp->pEditForm->RequestRedraw(true);
		}
	}
		break;
	case ID_FOOTER_REMOVE:
		{
			bool isFormulaFound=false;
			for(int i=0;i<myList->GetItemCount();i++)
			{
				if(myList->IsItemChecked(i)==true)
				{
					isFormulaFound=true;
					myKillFlag=true;
					myList->RefreshList(i,LIST_REFRESH_TYPE_ITEM_REMOVE);
					break;
				}
			}
			if(isFormulaFound==false)
			{
			    MessageBox msgbox;
			    msgbox.Construct("Bitte Item selektieren!", "Bitte wähle ein Item aus!" ,MSGBOX_STYLE_OK, 10000);
			    int modalResult = 0;
			    msgbox.ShowAndWait(modalResult);
			}
		}
		break;
	default:
		break;
	}
}


int Form1::GetItemCount(void)
{
	return itemCount;
}

Osp::Ui::Controls::ListItemBase* Form1::CreateItem(int index, int itemWidth)
{
	Osp::Ui::Controls::SimpleItem * pItem = new SimpleItem();
	pItem->Construct(Osp::Graphics::Dimension(itemWidth, 100), LIST_ANNEX_STYLE_RADIO);
	pItem->SetElement(item[index], null);
	return pItem;
}

bool Form1::DeleteItem(int index, Osp::Ui::Controls::ListItemBase* pItem, int itemWidth)
{
	if(myKillFlag==true)
	{
		myKillFlag=false;
		itemCount--;
		for(int i=index;(i+1)<9;i++)
		{
			item[i]=item[i+1];
		}
	}
	return false;
}

void Form1::OnListViewContextItemStateChanged
             (Osp::Ui::Controls::ListView &listView,
              int index, int elementId,
              Osp::Ui::Controls::ListContextItemStatus status) {
    AppLog("OnListViewContextItemStateChanged()");
}

void Form1::OnListViewItemStateChanged
             (Osp::Ui::Controls::ListView &listView,
              int index, int elementId,
              Osp::Ui::Controls::ListItemStatus status)
{
    //Uncheck all others
	if(status==LIST_ITEM_STATUS_CHECKED)
	{
		AppLog("Checked!");
		for(int i=0;i<myList->GetItemCount();i++)
		{
			if(i!=index)
			{
				myList->SetItemChecked(i,false);

			}
		}
	}
}

void Form1::OnListViewItemSwept
             (Osp::Ui::Controls::ListView &listView,
              int index,
              Osp::Ui::Controls::SweepDirection direction) {
    AppLog("OnListViewItemSwept()");
}

void Form1::OnListViewItemLongPressed
             (Osp::Ui::Controls::ListView &listView,
              int index,
              int elementId,
              bool &invokeListViewItemCallback) {
    AppLog("OnListViewItemLongPressed()");
}

