/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.query;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.server.support.query.CmisQlStrictLexer;
import org.apache.chemistry.opencmis.server.support.query.CmisQlStrictParser;
import org.apache.chemistry.opencmis.server.support.query.CmisQlStrictParser_CmisBaseGrammar;
import org.apache.chemistry.opencmis.server.support.query.CmisQueryWalker;
import org.apache.chemistry.opencmis.server.support.query.PredicateWalkerBase;
import org.apache.chemistry.opencmis.server.support.query.QueryObject;

public class QueryUtil
extends QueryObject {
    private CmisQueryWalker walker;

    public CmisQueryWalker getWalker(String statement) throws UnsupportedEncodingException, IOException, RecognitionException {
        ANTLRInputStream input = new ANTLRInputStream((InputStream)new ByteArrayInputStream(statement.getBytes("UTF-8")));
        CmisQlStrictLexer lexer = new CmisQlStrictLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CmisQlStrictParser parser = new CmisQlStrictParser((TokenStream)tokens);
        CmisQlStrictParser_CmisBaseGrammar.query_return parsedStatement = parser.query();
        if (parser.hasErrors()) {
            throw new CmisInvalidArgumentException(parser.getErrorMessages());
        }
        CommonTree parserTree = (CommonTree)parsedStatement.getTree();
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)parserTree);
        nodes.setTokenStream((TokenStream)tokens);
        CmisQueryWalker walker = new CmisQueryWalker((TreeNodeStream)nodes);
        return walker;
    }

    public CmisQueryWalker traverseStatement(String statement, QueryObject queryObj, PredicateWalkerBase pw) throws UnsupportedEncodingException, IOException, RecognitionException {
        this.walker = this.getWalker(statement);
        this.walker.query(queryObj, pw);
        this.walker.getWherePredicateTree();
        return this.walker;
    }

    public CmisQueryWalker traverseStatementAndCatchExc(String statement, QueryObject queryObj, PredicateWalkerBase pw) {
        QueryUtil queryUtil = new QueryUtil();
        try {
            return this.traverseStatement(statement, queryObj, pw);
        }
        catch (RecognitionException e) {
            String errorMsg = queryUtil.getErrorMessage();
            throw new CmisInvalidArgumentException("Walking of statement failed with RecognitionException error: \n   " + errorMsg);
        }
        catch (CmisBaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmisInvalidArgumentException("Walking of statement failed with exception: \n   " + e);
        }
    }

    public String getErrorMessage(RecognitionException e) {
        if (null == this.walker) {
            return e.toString();
        }
        return this.getErrorMessage((BaseRecognizer)this.walker, e);
    }

    private String getErrorMessage(BaseRecognizer recognizer, RecognitionException e) {
        String[] tokenNames = recognizer.getTokenNames();
        String hdr = "Line " + e.line + ":" + e.charPositionInLine;
        String msg = recognizer.getErrorMessage(e, tokenNames);
        return hdr + " " + msg;
    }
}

