/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisExtensionElementImpl
implements CmisExtensionElement {
    private static final long serialVersionUID = 1L;
    private String name;
    private String namespace;
    private String value;
    private Map<String, String> attributes;
    private List<CmisExtensionElement> children;

    public CmisExtensionElementImpl(String namespace, String name, Map<String, String> attributes, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name must set!");
        }
        this.name = name;
        this.namespace = namespace;
        this.value = value;
        this.children = Collections.emptyList();
        this.attributes = attributes != null ? Collections.unmodifiableMap(new HashMap<String, String>(attributes)) : Collections.emptyMap();
    }

    public CmisExtensionElementImpl(String namespace, String name, Map<String, String> attributes, List<CmisExtensionElement> children) {
        if (name == null) {
            throw new IllegalArgumentException("Name must set!");
        }
        this.name = name;
        this.namespace = namespace;
        this.value = null;
        this.children = children != null ? Collections.unmodifiableList(new ArrayList<CmisExtensionElement>(children)) : Collections.emptyList();
        this.attributes = attributes != null ? Collections.unmodifiableMap(new HashMap<String, String>(attributes)) : Collections.emptyMap();
    }

    public CmisExtensionElementImpl(CmisExtensionElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Element must set!");
        }
        if (element.getName() == null) {
            throw new IllegalArgumentException("Name must set!");
        }
        this.name = element.getName();
        this.namespace = element.getNamespace();
        this.value = element.getValue();
        this.children = element.getChildren();
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public List<CmisExtensionElement> getChildren() {
        return this.children;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return (this.namespace == null ? "" : "{" + this.namespace + "}") + this.name + " " + this.attributes + ": " + (this.children.isEmpty() ? this.value : this.children.toString());
    }
}

