/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PortProvider;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisACLType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumACLPropagation;
import org.apache.chemistry.opencmis.commons.spi.AclService;

public class AclServiceImpl
extends AbstractWebServicesService
implements AclService {
    private final PortProvider fPortProvider;

    public AclServiceImpl(Session session, PortProvider portProvider) {
        this.setSession(session);
        this.fPortProvider = portProvider;
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addACEs, Acl removeACEs, AclPropagation aclPropagation, ExtensionsData extension) {
        ACLServicePort port = this.fPortProvider.getACLServicePort();
        try {
            return Converter.convert((CmisACLType)port.applyACL(repositoryId, objectId, Converter.convert((Acl)addACEs), Converter.convert((Acl)removeACEs), (EnumACLPropagation)Converter.convert(EnumACLPropagation.class, (Enum)aclPropagation), Converter.convert((ExtensionsData)extension)));
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        ACLServicePort port = this.fPortProvider.getACLServicePort();
        try {
            return Converter.convert((CmisACLType)port.getACL(repositoryId, objectId, onlyBasicPermissions, Converter.convert((ExtensionsData)extension)));
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }
}

