/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryInfoCache;
import org.apache.chemistry.opencmis.client.bindings.impl.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
implements RepositoryService,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Session session;

    public RepositoryServiceImpl(Session session) {
        this.session = session;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        RepositoryInfo result = null;
        boolean hasExtension = extension != null && !extension.getExtensions().isEmpty();
        RepositoryInfoCache cache = CmisBindingsHelper.getRepositoryInfoCache(this.session);
        if (!hasExtension && (result = cache.get(repositoryId)) != null) {
            return result;
        }
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getRepositoryInfo(repositoryId, extension);
        if (!hasExtension) {
            cache.put(result);
        }
        return result;
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        List result = null;
        boolean hasExtension = extension != null && !extension.getExtensions().isEmpty();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getRepositoryInfos(extension);
        if (!hasExtension && result != null) {
            RepositoryInfoCache cache = CmisBindingsHelper.getRepositoryInfoCache(this.session);
            for (RepositoryInfo rid : result) {
                cache.put(rid);
            }
        }
        return result;
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        TypeDefinitionList result = null;
        boolean hasExtension = extension != null && !extension.getExtensions().isEmpty();
        boolean propDefs = includePropertyDefinitions == null ? false : includePropertyDefinitions;
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
        if (!hasExtension && propDefs && result != null) {
            TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
            for (TypeDefinition tdd : result.getList()) {
                cache.put(repositoryId, tdd);
            }
        }
        return result;
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        TypeDefinition result = null;
        boolean hasExtension = extension != null && !extension.getExtensions().isEmpty();
        TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
        if (!hasExtension && (result = cache.get(repositoryId, typeId)) != null) {
            return result;
        }
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getTypeDefinition(repositoryId, typeId, extension);
        if (!hasExtension && result != null) {
            cache.put(repositoryId, result);
        }
        return result;
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        List result = null;
        boolean hasExtension = extension != null && !extension.getExtensions().isEmpty();
        boolean propDefs = includePropertyDefinitions == null ? false : includePropertyDefinitions;
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, extension);
        if (!hasExtension && propDefs && result != null) {
            TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
            this.addToTypeCache(cache, repositoryId, result);
        }
        return result;
    }

    private void addToTypeCache(TypeDefinitionCache cache, String repositoryId, List<TypeDefinitionContainer> containers) {
        if (containers == null) {
            return;
        }
        for (TypeDefinitionContainer container : containers) {
            cache.put(repositoryId, container.getTypeDefinition());
            this.addToTypeCache(cache, repositoryId, container.getChildren());
        }
    }
}

