package de.accso.java8samples.beispiel5.parallelisierung.b_max_skaliertnicht;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.Random;

public class Beispiel5b_max {
    private static final int ARRAY_SIZE = 40000;

    public static void main(String[] args) {
        // Anlegen und Befuellen eines Arrays
        final int[] array = createRandomArray(ARRAY_SIZE);
        // Hilfsklasse auf Basis von java.time.*
        final Timer timer=new Timer();
        // Parallele Ausfuehrung
        timer.start();
        OptionalInt resPar      = Arrays.stream(array).parallel().max();
        Duration durPar = timer.getDuration();
        // Sequentielle Ausfuehrung
        timer.start();
        OptionalInt resSeq      = Arrays.stream(array).max();
        Duration durSeq = timer.getDuration();

        // kein Gewinn durch Parallelisierung (Gegenbeispiel, im Artikel nicht weiter ausgefuehrt)
        System.out.println("Result (sequential computation): " + resSeq + " (computation time: " + durSeq + ")");
        System.out.println("Result (parallel computation):   " + resPar + " (computation time: " + durPar + ")");
        System.out.println("Speedup: " + (double) durSeq.toMillis() / durPar.toMillis());
    }

    private static int[] createRandomArray(int size) {
        int[] array = new int[size];
        Random rnd = new Random();

        for (int i = 0; i < size; i++) {
            array[i] = rnd.nextInt(999_999_999);
        }

        return array;
    }

    private static class Timer {
        private Clock clock = Clock.systemUTC();
        private Instant startTime;

        public void start() {
            startTime = clock.instant();
        }

        public Duration getDuration() {
            return Duration.between(startTime, clock.instant());
        }
    }
}

