﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Data.Linq;

namespace WP7Charts3
{
    public partial class MainPage : PhoneApplicationPage
    {
        MyDataContext myDb;
        public Table<Kunden> myKunden;
        public Table<Statii> myStatii;
        public List<Statii> myStatiiEditingList;

        // Constructor
        public MainPage()
        {
            InitializeComponent();
            myDb = new MyDataContext("Data Source=isostore:/DB.sdf");
            using (var db = myDb)
            {
                if (!db.DatabaseExists())
                    db.CreateDatabase();
            }
            myStatiiEditingList = null;


        }

        private void CmdPopulate_Click(object sender, RoutedEventArgs e)
        {
            using (var myDb = new MyDataContext("Data Source=isostore:/DB.sdf"))
            {
                myStatii = myDb.Statii;
                myKunden = myDb.Kunden;

                Statii silverStatus=new Statii();
                silverStatus.myName = "Silver";
                myStatii.InsertOnSubmit(silverStatus);
                Statii goldStatus = new Statii();
                goldStatus.myName = "Gold";
                myStatii.InsertOnSubmit(goldStatus);
                Statii platinStatus = new Statii();
                platinStatus.myName = "Platin";
                myStatii.InsertOnSubmit(platinStatus);
                //BP vor und nach dieser Zeile !!
                myDb.SubmitChanges();

                Kunden arbeitsKunde;
                arbeitsKunde = new Kunden();
                arbeitsKunde.myName = "A";
                arbeitsKunde.mySurName = "SurA";
                arbeitsKunde.myStatus = silverStatus.myStatusId;
                myKunden.InsertOnSubmit(arbeitsKunde);
                arbeitsKunde = new Kunden();
                arbeitsKunde.myName = "B";
                arbeitsKunde.mySurName = "SurB";
                arbeitsKunde.myStatus = silverStatus.myStatusId;
                myKunden.InsertOnSubmit(arbeitsKunde);
                arbeitsKunde = new Kunden();
                arbeitsKunde.myName = "C";
                arbeitsKunde.mySurName = "SurC";
                arbeitsKunde.myStatus = goldStatus.myStatusId;
                myKunden.InsertOnSubmit(arbeitsKunde);
                arbeitsKunde = new Kunden();
                arbeitsKunde.myName = "D";
                arbeitsKunde.mySurName = "SurD";
                arbeitsKunde.myStatus = platinStatus.myStatusId;
                myKunden.InsertOnSubmit(arbeitsKunde);
                myDb.SubmitChanges();

                myDb.Dispose();
            }
        }

        private void CmdReadStatii_Click(object sender, RoutedEventArgs e)
        {
            myDb = new MyDataContext("Data Source=isostore:/DB.sdf");
            var r = from p in myDb.Statii
                    select p;

            myStatiiEditingList = new List<Statii>();
            foreach (var D in r)
            {
                myStatiiEditingList.Add(D);
            }
            //BP hier
            myStatiiEditingList = myStatiiEditingList;
        }

        private void CmdRenameStatii_Click(object sender, RoutedEventArgs e)
        {
            foreach (Statii s in myStatiiEditingList)
            {
                if (s.myName == "Silver")
                {
                    s.myName = "OW Ruby";
                    myDb.SubmitChanges();
                }
            }
        }

        private void CmdFindSilver_Click(object sender, RoutedEventArgs e)
        {
            Statii silverStatus=null;
            myDb = new MyDataContext("Data Source=isostore:/DB.sdf");
            
            foreach(Statii s in myStatiiEditingList)
            {
                if(s.myName=="Silver" || s.myName=="OW Ruby")
                    silverStatus=s;
            }

            var r = from p in myDb.Kunden
                    where p.myStatus==silverStatus.myStatusId
                    select p;

            List<Kunden> myReadingList = new List<Kunden>();
            foreach (var D in r)
            {
                myReadingList.Add(D);
            }
            //BP hier
            myReadingList = myReadingList;
        }
    }
}