/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.DatastoreImpl;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Morphia {
    private final Mapper mapper = new Mapper();

    public Morphia() {
        this(Collections.EMPTY_SET);
    }

    public Morphia(Set<Class> classesToMap) {
        for (Class c : classesToMap) {
            this.map(c);
        }
    }

    public synchronized Morphia map(Class entityClass) {
        if (!this.mapper.isMapped(entityClass)) {
            this.mapper.addMappedClass(entityClass);
        }
        return this;
    }

    public synchronized Morphia mapPackageFromClass(Class clazz) {
        return this.mapPackage(clazz.getPackage().getName(), false);
    }

    public synchronized Morphia mapPackage(String packageName) {
        return this.mapPackage(packageName, false);
    }

    public synchronized Morphia mapPackage(String packageName, boolean ignoreInvalidClasses) {
        try {
            for (Class<?> c : ReflectionUtils.getClasses(packageName)) {
                try {
                    Embedded embeddedAnn = ReflectionUtils.getClassEmbeddedAnnotation(c);
                    Entity enityAnn = ReflectionUtils.getClassEntityAnnotation(c);
                    if (enityAnn == null && embeddedAnn == null) continue;
                    this.map(c);
                }
                catch (MappingException ex) {
                    if (ignoreInvalidClasses) continue;
                    throw ex;
                }
            }
            return this;
        }
        catch (IOException ioex) {
            throw new MappingException("Could not get map classes from package " + packageName, ioex);
        }
        catch (ClassNotFoundException cnfex) {
            throw new MappingException("Could not get map classes from package " + packageName, cnfex);
        }
    }

    public boolean isMapped(Class entityClass) {
        return this.mapper.isMapped(entityClass);
    }

    public <T> T fromDBObject(Class<T> entityClass, DBObject dbObject) {
        return this.fromDBObject(entityClass, dbObject, this.mapper.createEntityCache());
    }

    public <T> T fromDBObject(Class<T> entityClass, DBObject dbObject, EntityCache cache) {
        if (!entityClass.isInterface() && !this.mapper.isMapped(entityClass)) {
            throw new MappingException("Trying to map to an unmapped class: " + entityClass.getName());
        }
        try {
            return (T)this.mapper.fromDBObject(entityClass, (DBObject)((BasicDBObject)dbObject), cache);
        }
        catch (Exception e) {
            throw new MappingException("Could not map entity from DBObject", e);
        }
    }

    public DBObject toDBObject(Object entity) {
        try {
            return this.mapper.toDBObject(entity);
        }
        catch (Exception e) {
            throw new MappingException("Could not map entity to DBObject", e);
        }
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    @Deprecated
    public Datastore createDatastore(String dbName) {
        return this.createDatastore(dbName, null, null);
    }

    @Deprecated
    public Datastore createDatastore(String dbName, String user, char[] pw) {
        try {
            return this.createDatastore(new Mongo(), dbName, user, pw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Datastore createDatastore(Mongo mon, String dbName, String user, char[] pw) {
        return new DatastoreImpl(this, mon, dbName, user, pw);
    }

    public Datastore createDatastore(Mongo mongo, String dbName) {
        return this.createDatastore(mongo, dbName, null, null);
    }
}

