/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.converters;

import com.google.code.morphia.converters.BooleanConverter;
import com.google.code.morphia.converters.ByteConverter;
import com.google.code.morphia.converters.CharArrayConverter;
import com.google.code.morphia.converters.CharacterConverter;
import com.google.code.morphia.converters.ClassConverter;
import com.google.code.morphia.converters.ConverterNotFoundException;
import com.google.code.morphia.converters.DateConverter;
import com.google.code.morphia.converters.DoubleConverter;
import com.google.code.morphia.converters.EnumConverter;
import com.google.code.morphia.converters.EnumSetConverter;
import com.google.code.morphia.converters.FloatConverter;
import com.google.code.morphia.converters.IntegerConverter;
import com.google.code.morphia.converters.IterableConverter;
import com.google.code.morphia.converters.KeyConverter;
import com.google.code.morphia.converters.LocaleConverter;
import com.google.code.morphia.converters.LongConverter;
import com.google.code.morphia.converters.MapOfValuesConverter;
import com.google.code.morphia.converters.ObjectIdConverter;
import com.google.code.morphia.converters.PassthroughConverter;
import com.google.code.morphia.converters.SerializedObjectConverter;
import com.google.code.morphia.converters.ShortConverter;
import com.google.code.morphia.converters.SimpleValueConverter;
import com.google.code.morphia.converters.StringConverter;
import com.google.code.morphia.converters.TimestampConverter;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.mapping.MapperOptions;
import com.google.code.morphia.mapping.MappingException;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConverters {
    private static final Logr log = MorphiaLoggerFactory.get(DefaultConverters.class);
    private List<TypeConverter> untypedTypeEncoders = new LinkedList<TypeConverter>();
    private Map<Class, List<TypeConverter>> tcMap = new ConcurrentHashMap<Class, List<TypeConverter>>();
    private List<Class<? extends TypeConverter>> registeredConverterClasses = new LinkedList<Class<? extends TypeConverter>>();
    private Mapper mapr;

    public DefaultConverters() {
        this.addConverter(new PassthroughConverter(DBObject.class, BasicDBObject.class));
        this.addConverter(new PassthroughConverter(byte[].class));
        this.addConverter(new EnumSetConverter());
        this.addConverter(new EnumConverter());
        this.addConverter(new StringConverter());
        this.addConverter(new CharacterConverter());
        this.addConverter(new ByteConverter());
        this.addConverter(new BooleanConverter());
        this.addConverter(new DoubleConverter());
        this.addConverter(new FloatConverter());
        this.addConverter(new LongConverter());
        this.addConverter(new LocaleConverter());
        this.addConverter(new ShortConverter());
        this.addConverter(new IntegerConverter());
        this.addConverter(new SerializedObjectConverter());
        this.addConverter(new CharArrayConverter());
        this.addConverter(new DateConverter());
        this.addConverter(new KeyConverter());
        this.addConverter(new MapOfValuesConverter(this));
        this.addConverter(new IterableConverter(this));
        this.addConverter(new ClassConverter());
        this.addConverter(new ObjectIdConverter());
        this.addConverter(new TimestampConverter());
        this.addConverter(new PassthroughConverter());
    }

    public TypeConverter addConverter(TypeConverter tc) {
        if (tc.getSupportedTypes() != null) {
            for (Class c : tc.getSupportedTypes()) {
                this.addTypedConverter(c, tc);
            }
        } else {
            this.untypedTypeEncoders.add(tc);
        }
        tc.setMapper(this.mapr);
        this.registeredConverterClasses.add(tc.getClass());
        return tc;
    }

    public TypeConverter addConverter(Class<? extends TypeConverter> clazz) {
        return this.addConverter((TypeConverter)this.mapr.getOptions().objectFactory.createInstance(clazz));
    }

    public void removeConverter(TypeConverter tc) {
        if (tc.getSupportedTypes() == null) {
            this.untypedTypeEncoders.remove(tc);
        } else {
            for (List<TypeConverter> tcList : this.tcMap.values()) {
                if (!tcList.contains(tc)) continue;
                tcList.remove(tc);
            }
        }
        this.registeredConverterClasses.remove(tc.getClass());
    }

    public boolean isRegistered(Class<? extends TypeConverter> tcClass) {
        return this.registeredConverterClasses.contains(tcClass);
    }

    private void addTypedConverter(Class type, TypeConverter tc) {
        if (this.tcMap.containsKey(type)) {
            this.tcMap.get(type).add(0, tc);
            log.warning("Added duplicate converter for " + type + " ; " + this.tcMap.get(type));
        } else {
            ArrayList<TypeConverter> vals = new ArrayList<TypeConverter>();
            vals.add(tc);
            this.tcMap.put(type, vals);
        }
    }

    public void fromDBObject(DBObject dbObj, MappedField mf, Object targetEntity) {
        Object object = mf.getDbObjectValue(dbObj);
        if (object == null) {
            this.processMissingField(mf);
        } else {
            TypeConverter enc = this.getEncoder(mf);
            Object decodedValue = enc.decode(mf.getType(), object, mf);
            try {
                mf.setFieldValue(targetEntity, decodedValue);
            }
            catch (IllegalArgumentException e) {
                throw new MappingException("Error setting value from converter (" + enc.getClass().getSimpleName() + ") for " + mf.getFullName() + " to " + decodedValue);
            }
        }
    }

    protected void processMissingField(MappedField mf) {
    }

    private TypeConverter getEncoder(MappedField mf) {
        return this.getEncoder(null, mf);
    }

    private TypeConverter getEncoder(Object val, MappedField mf) {
        List<TypeConverter> tcs = null;
        if (val != null) {
            tcs = this.tcMap.get(val.getClass());
        }
        if (tcs == null || tcs.size() > 0 && tcs.get(0) instanceof PassthroughConverter) {
            tcs = this.tcMap.get(mf.getType());
        }
        if (tcs != null) {
            if (tcs.size() > 1) {
                log.warning("Duplicate converter for " + mf.getType() + ", returning first one from " + tcs);
            }
            return tcs.get(0);
        }
        for (TypeConverter tc : this.untypedTypeEncoders) {
            if (!tc.canHandle(mf) && (val == null || !tc.isSupported(val.getClass(), mf))) continue;
            return tc;
        }
        throw new ConverterNotFoundException("Cannot find encoder for " + mf.getType() + " as need for " + mf.getFullName());
    }

    private TypeConverter getEncoder(Class c) {
        List<TypeConverter> tcs = this.tcMap.get(c);
        if (tcs != null) {
            if (tcs.size() > 1) {
                log.warning("Duplicate converter for " + c + ", returning first one from " + tcs);
            }
            return tcs.get(0);
        }
        for (TypeConverter tc : this.untypedTypeEncoders) {
            if (!tc.canHandle(c)) continue;
            return tc;
        }
        throw new ConverterNotFoundException("Cannot find encoder for " + c.getName());
    }

    public void toDBObject(Object containingObject, MappedField mf, DBObject dbObj, MapperOptions opts) {
        Object fieldValue = mf.getFieldValue(containingObject);
        TypeConverter enc = this.getEncoder(fieldValue, mf);
        Object encoded = enc.encode(fieldValue, mf);
        if (encoded != null || opts.storeNulls) {
            dbObj.put(mf.getNameToStore(), encoded);
        }
    }

    public Object decode(Class c, Object fromDBObject, MappedField mf) {
        if (c == null) {
            c = fromDBObject.getClass();
        }
        return this.getEncoder(c).decode(c, fromDBObject, mf);
    }

    public Object decode(Class c, Object fromDBObject) {
        return this.decode(c, fromDBObject, null);
    }

    public Object encode(Object o) {
        return this.encode(o.getClass(), o);
    }

    public Object encode(Class c, Object o) {
        return this.getEncoder(c).encode(o);
    }

    public void setMapper(Mapper mapr) {
        this.mapr = mapr;
        for (List<TypeConverter> tcs : this.tcMap.values()) {
            for (TypeConverter tc : tcs) {
                tc.setMapper(mapr);
            }
        }
        for (TypeConverter tc : this.untypedTypeEncoders) {
            tc.setMapper(mapr);
        }
    }

    public boolean hasSimpleValueConverter(MappedField c) {
        TypeConverter conv = this.getEncoder(c);
        return conv instanceof SimpleValueConverter;
    }

    public boolean hasSimpleValueConverter(Class c) {
        TypeConverter conv = this.getEncoder(c);
        return conv instanceof SimpleValueConverter;
    }

    public boolean hasSimpleValueConverter(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Class) {
            return this.hasSimpleValueConverter((Class)o);
        }
        if (o instanceof MappedField) {
            return this.hasSimpleValueConverter((MappedField)o);
        }
        return this.hasSimpleValueConverter(o.getClass());
    }

    public boolean hasDbObjectConverter(MappedField c) {
        TypeConverter conv = this.getEncoder(c);
        return conv != null && !(conv instanceof PassthroughConverter) && !(conv instanceof SimpleValueConverter);
    }

    public boolean hasDbObjectConverter(Class c) {
        TypeConverter conv = this.getEncoder(c);
        return conv != null && !(conv instanceof PassthroughConverter) && !(conv instanceof SimpleValueConverter);
    }
}

