/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping;

import com.google.code.morphia.ObjectFactory;
import com.google.code.morphia.annotations.ConstructorArgs;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.mapping.MappingException;
import com.mongodb.DBObject;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultCreator
implements ObjectFactory {
    private static final Logr log = MorphiaLoggerFactory.get(DefaultCreator.class);

    public Object createInstance(Class clazz) {
        return DefaultCreator.createInst(clazz);
    }

    public Object createInstance(Class clazz, DBObject dbObj) {
        Class c = this.getClass(dbObj);
        if (c == null) {
            c = clazz;
        }
        return this.createInstance(c);
    }

    public Object createInstance(Mapper mapr, MappedField mf, DBObject dbObj) {
        Class c = this.getClass(dbObj);
        if (c == null) {
            c = mf.isSingleValue ? mf.getConcreteType() : mf.getSubClass();
        }
        try {
            return this.createInstance(c, dbObj);
        }
        catch (RuntimeException e) {
            ConstructorArgs argAnn = mf.getAnnotation(ConstructorArgs.class);
            if (argAnn == null) {
                throw e;
            }
            Object[] args = new Object[argAnn.value().length];
            Class[] argTypes = new Class[argAnn.value().length];
            for (int i = 0; i < argAnn.value().length; ++i) {
                Object val;
                args[i] = val = dbObj.get(argAnn.value()[i]);
                argTypes[i] = val.getClass();
            }
            try {
                Constructor ctor = c.getDeclaredConstructor(argTypes);
                ctor.setAccessible(true);
                return ctor.newInstance(args);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private Class getClass(DBObject dbObj) {
        Class<?> c;
        block3: {
            String className = (String)dbObj.get("className");
            c = null;
            if (className != null) {
                try {
                    c = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    if (!log.isWarningEnabled()) break block3;
                    log.warning("Class not found defined in dbObj: ", e);
                }
            }
        }
        return c;
    }

    public Map createMap(MappedField mf) {
        return (Map)DefaultCreator.newInstance(mf.getCTor(), HashMap.class);
    }

    public List createList(MappedField mf) {
        return (List)DefaultCreator.newInstance(mf.getCTor(), ArrayList.class);
    }

    public Set createSet(MappedField mf) {
        return (Set)DefaultCreator.newInstance(mf.getCTor(), HashSet.class);
    }

    public static Object createInst(Class clazz) {
        try {
            return DefaultCreator.getNoArgsConstructor(clazz).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object newInstance(Constructor tryMe, Class fallbackType) {
        if (tryMe != null) {
            tryMe.setAccessible(true);
            try {
                return tryMe.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return DefaultCreator.createInst(fallbackType);
    }

    private static Constructor getNoArgsConstructor(Class ctorType) {
        try {
            Constructor ctor = ctorType.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (NoSuchMethodException e) {
            throw new MappingException("No usable constructor for " + ctorType.getName(), e);
        }
    }
}

