/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping;

import com.google.code.morphia.mapping.CustomMapper;
import com.google.code.morphia.mapping.MapOrCollectionMF;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbeddedMapper
implements CustomMapper {
    EmbeddedMapper() {
    }

    @Override
    public void toDBObject(Object entity, MappedField mf, BasicDBObject dbObject, Map<Object, DBObject> involvedObjects, Mapper mapr) {
        String name = mf.getNameToStore();
        Object fieldValue = mf.getFieldValue(entity);
        if (mf.isMap()) {
            this.writeMap(mf, dbObject, involvedObjects, name, fieldValue, mapr);
        } else if (mf.isMultipleValues()) {
            this.writeCollection(mf, dbObject, involvedObjects, name, fieldValue, mapr);
        } else {
            DBObject dbObj;
            if (mapr.converters.hasDbObjectConverter(mf) || mapr.converters.hasDbObjectConverter(entity.getClass())) {
                mapr.converters.toDBObject(entity, mf, (DBObject)dbObject, mapr.getOptions());
                return;
            }
            DBObject dBObject = dbObj = fieldValue == null ? null : mapr.toDBObject(fieldValue, involvedObjects);
            if (dbObj != null) {
                if (!EmbeddedMapper.shouldSaveClassName(fieldValue, dbObj, mf)) {
                    dbObj.removeField("className");
                }
                if (dbObj.keySet().size() > 0 || mapr.getOptions().storeEmpties) {
                    dbObject.put(name, (Object)dbObj);
                }
            }
        }
    }

    private void writeCollection(MappedField mf, BasicDBObject dbObject, Map<Object, DBObject> involvedObjects, String name, Object fieldValue, Mapper mapr) {
        List<Object> coll = null;
        coll = mf.isArray ? Arrays.asList((Object[])fieldValue) : (List<Object>)fieldValue;
        if (coll != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object t : coll) {
                if (mapr.converters.hasSimpleValueConverter(mf) || mapr.converters.hasSimpleValueConverter(t.getClass())) {
                    values.add(mapr.converters.encode(t));
                    continue;
                }
                Object val = Collection.class.isAssignableFrom(t.getClass()) || Map.class.isAssignableFrom(t.getClass()) ? mapr.toMongoObject(t, true) : mapr.toDBObject(t, involvedObjects);
                if (!EmbeddedMapper.shouldSaveClassName(t, val, mf)) {
                    ((DBObject)val).removeField("className");
                }
                values.add(val);
            }
            if (values.size() > 0 || mapr.getOptions().storeEmpties) {
                dbObject.put(name, values);
            }
        }
    }

    private void writeMap(MappedField mf, BasicDBObject dbObject, Map<Object, DBObject> involvedObjects, String name, Object fieldValue, Mapper mapr) {
        Map map = (Map)fieldValue;
        if (map != null) {
            BasicDBObject values = new BasicDBObject();
            for (Map.Entry entry : map.entrySet()) {
                Object val;
                Object entryVal = entry.getValue();
                if (entryVal == null) {
                    val = null;
                } else if (mapr.converters.hasSimpleValueConverter(mf) || mapr.converters.hasSimpleValueConverter(entryVal.getClass())) {
                    val = mapr.converters.encode(entryVal);
                } else {
                    val = Map.class.isAssignableFrom(entryVal.getClass()) || Collection.class.isAssignableFrom(entryVal.getClass()) ? mapr.toMongoObject(entryVal, true) : mapr.toDBObject(entryVal, involvedObjects);
                    if (!EmbeddedMapper.shouldSaveClassName(entryVal, val, mf)) {
                        ((DBObject)val).removeField("className");
                    }
                }
                String strKey = mapr.converters.encode(entry.getKey()).toString();
                values.put(strKey, val);
            }
            if (values.size() > 0 || mapr.getOptions().storeEmpties) {
                dbObject.put(name, (Object)values);
            }
        }
    }

    @Override
    public void fromDBObject(DBObject dbObject, MappedField mf, Object entity, EntityCache cache, Mapper mapr) {
        try {
            if (mf.isMap()) {
                this.readMap(dbObject, mf, entity, cache, mapr);
            } else if (mf.isMultipleValues()) {
                this.readCollection(dbObject, mf, entity, cache, mapr);
            } else {
                Object dbVal = mf.getDbObjectValue(dbObject);
                if (dbVal != null) {
                    boolean isDBObject;
                    boolean bl = isDBObject = dbVal instanceof DBObject && !(dbVal instanceof BasicDBList);
                    if (isDBObject && (mapr.converters.hasDbObjectConverter(mf) || mapr.converters.hasDbObjectConverter(mf.getType()))) {
                        mapr.converters.fromDBObject((DBObject)dbVal, mf, entity);
                        return;
                    }
                    Object refObj = null;
                    if (mapr.converters.hasSimpleValueConverter(mf) || mapr.converters.hasSimpleValueConverter(mf.getType())) {
                        refObj = mapr.converters.decode(mf.getType(), dbVal, mf);
                    } else {
                        refObj = mapr.getOptions().objectFactory.createInstance(mapr, mf, (DBObject)dbVal);
                        refObj = mapr.fromDb((DBObject)dbVal, refObj, cache);
                    }
                    if (refObj != null) {
                        mf.setFieldValue(entity, refObj);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void readCollection(DBObject dbObject, MappedField mf, Object entity, EntityCache cache, Mapper mapr) {
        Collection<Object> values = mf.isSet() ? mapr.getOptions().objectFactory.createSet(mf) : mapr.getOptions().objectFactory.createList(mf);
        Object dbVal = mf.getDbObjectValue(dbObject);
        if (dbVal != null) {
            List dbVals = null;
            if (dbVal instanceof List) {
                dbVals = (List)dbVal;
            } else {
                dbVals = new BasicDBList();
                dbVals.add(dbVal);
            }
            for (Object o : dbVals) {
                DBObject dbObj = (DBObject)o;
                Object newEntity = null;
                if (dbObj != null) {
                    newEntity = mapr.converters.hasSimpleValueConverter(mf) || mapr.converters.hasSimpleValueConverter(mf.getSubClass()) ? mapr.converters.decode(mf.getSubClass(), dbObj, mf) : this.readMapOrCollectionOrEntity(dbObj, mf, cache, mapr);
                }
                values.add(newEntity);
            }
        }
        if (values.size() > 0) {
            if (mf.getType().isArray()) {
                mf.setFieldValue(entity, ReflectionUtils.convertToArray(mf.getSubClass(), ReflectionUtils.iterToList(values)));
            } else {
                mf.setFieldValue(entity, values);
            }
        }
    }

    private void readMap(DBObject dbObject, MappedField mf, Object entity, EntityCache cache, Mapper mapr) {
        Map map = mapr.getOptions().objectFactory.createMap(mf);
        BasicDBObject dbVal = (BasicDBObject)mf.getDbObjectValue(dbObject);
        if (dbVal != null) {
            for (Map.Entry entry : dbVal.entrySet()) {
                Object val = entry.getValue();
                Object newEntity = null;
                if (val != null) {
                    if (mapr.converters.hasSimpleValueConverter(mf) || mapr.converters.hasSimpleValueConverter(mf.getSubClass())) {
                        newEntity = mapr.converters.decode(mf.getSubClass(), val, mf);
                    } else if (val instanceof DBObject) {
                        newEntity = this.readMapOrCollectionOrEntity((DBObject)val, mf, cache, mapr);
                    } else {
                        throw new MappingException("Embedded element isn't a DBObject! How can it be that is a " + val.getClass());
                    }
                }
                Object objKey = mapr.converters.decode(mf.getMapKeyClass(), entry.getKey());
                map.put(objKey, newEntity);
            }
        }
        if (map.size() > 0) {
            mf.setFieldValue(entity, map);
        }
    }

    private Object readMapOrCollectionOrEntity(DBObject dbObj, MappedField mf, EntityCache cache, Mapper mapr) {
        if (Map.class.isAssignableFrom(mf.getSubClass()) || Iterable.class.isAssignableFrom(mf.getSubClass())) {
            MapOrCollectionMF mocMF = new MapOrCollectionMF((ParameterizedType)mf.getSubType());
            mapr.fromDb(dbObj, mocMF, cache);
            return mocMF.getValue();
        }
        Object newEntity = mapr.getOptions().objectFactory.createInstance(mapr, mf, dbObj);
        return mapr.fromDb(dbObj, newEntity, cache);
    }

    public static boolean shouldSaveClassName(Object rawVal, Object convertedVal, MappedField mf) {
        if (rawVal == null || mf == null) {
            return true;
        }
        if (mf.isSingleValue()) {
            return !mf.getType().equals(rawVal.getClass()) || convertedVal instanceof BasicDBList;
        }
        return convertedVal == null || !(convertedVal instanceof DBObject) || mf.getSubClass().isInterface() || Modifier.isAbstract(mf.getSubClass().getModifiers()) || !mf.getSubClass().equals(rawVal.getClass());
    }
}

