/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping;

import com.google.code.morphia.annotations.AlsoLoad;
import com.google.code.morphia.annotations.ConstructorArgs;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.Indexed;
import com.google.code.morphia.annotations.NotSaved;
import com.google.code.morphia.annotations.Property;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Serialized;
import com.google.code.morphia.annotations.Version;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.DBObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedField {
    private static final Logr log = MorphiaLoggerFactory.get(MappedField.class);
    public static List<Class<? extends Annotation>> interestingAnnotations = new ArrayList<Class>(Arrays.asList(Serialized.class, Indexed.class, Property.class, Reference.class, Embedded.class, Id.class, Version.class, ConstructorArgs.class, AlsoLoad.class, NotSaved.class));
    protected Class persistedClass;
    protected Field field;
    protected Class realType;
    protected Constructor ctor;
    protected String name;
    protected Map<Class<? extends Annotation>, Annotation> foundAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
    protected Type subType = null;
    protected Type mapKeyType = null;
    protected boolean isSingleValue = true;
    protected boolean isMongoType = false;
    protected boolean isMap = false;
    protected boolean isSet = false;
    protected boolean isArray = false;
    protected boolean isCollection = false;

    MappedField(Field f, Class<?> clazz) {
        f.setAccessible(true);
        this.field = f;
        this.persistedClass = clazz;
        this.discover();
    }

    protected MappedField() {
    }

    protected void discover() {
        for (Class<? extends Annotation> clazz : interestingAnnotations) {
            this.addAnnotation(clazz);
        }
        this.name = this.getMappedFieldName();
        this.realType = this.discoverType();
        this.ctor = this.discoverCTor();
        this.discoverMultivalued();
        this.isMongoType = ReflectionUtils.isPropertyType(this.realType);
        if (!this.isMongoType && this.subType != null) {
            this.isMongoType = ReflectionUtils.isPropertyType(this.subType);
        }
        if (!(this.isMongoType || this.isSingleValue || this.subType != null && !this.subType.equals(Object.class))) {
            if (log.isWarningEnabled()) {
                log.warning("The multi-valued field '" + this.getFullName() + "' is a possible heterogenous collection. It cannot be verified. Please declare a valid type to get rid of this warning. " + this.subType);
            }
            this.isMongoType = true;
        }
    }

    private void discoverMultivalued() {
        if (this.realType.isArray() || Collection.class.isAssignableFrom(this.realType) || Map.class.isAssignableFrom(this.realType)) {
            this.isSingleValue = false;
            this.isMap = Map.class.isAssignableFrom(this.realType);
            this.isSet = Set.class.isAssignableFrom(this.realType);
            this.isCollection = Collection.class.isAssignableFrom(this.realType);
            this.isArray = this.realType.isArray();
            if (!(this.isMap || this.isSet || this.isCollection || this.isArray)) {
                throw new MappingException("type is not a map/set/collection/array : " + this.realType);
            }
            Type type = this.realType.isArray() ? this.realType.getComponentType() : (this.subType = ReflectionUtils.getParameterizedType(this.field, this.isMap ? 1 : 0));
            if (this.isMap) {
                this.mapKeyType = ReflectionUtils.getParameterizedType(this.field, 0);
            }
        }
    }

    private Class discoverType() {
        Class<?> type = this.field.getType();
        Type gType = this.field.getGenericType();
        TypeVariable tv = null;
        ParameterizedType pt = null;
        if (gType instanceof TypeVariable) {
            tv = (TypeVariable)gType;
        } else if (gType instanceof ParameterizedType) {
            pt = (ParameterizedType)gType;
        }
        if (tv != null) {
            type = ReflectionUtils.getTypeArgument(this.persistedClass, tv);
        } else if (pt != null && log.isDebugEnabled()) {
            log.debug("found instance of ParameterizedType : " + pt);
        }
        if (Object.class.equals((Object)this.realType) && (tv != null || pt != null) && log.isWarningEnabled()) {
            log.warning("Parameterized types are treated as untyped Objects. See field '" + this.field.getName() + "' on " + this.field.getDeclaringClass());
        }
        if (type == null) {
            throw new MappingException("A type could not be found for " + this.field);
        }
        return type;
    }

    private Constructor discoverCTor() {
        Constructor returnCtor;
        block13: {
            returnCtor = null;
            Class ctorType = null;
            for (Annotation an : this.foundAnnotations.values()) {
                try {
                    Method m = an.getClass().getMethod("concreteClass", new Class[0]);
                    m.setAccessible(true);
                    Object o = m.invoke((Object)an, new Object[0]);
                    if (o == null || o.equals(Object.class)) continue;
                    ctorType = (Class)o;
                    break;
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalArgumentException e) {
                    if (!log.isWarningEnabled()) continue;
                    log.warning("There should not be an argument", e);
                }
                catch (Exception e) {
                    if (!log.isWarningEnabled()) continue;
                    log.warning("", e);
                }
            }
            if (ctorType != null) {
                try {
                    returnCtor = ctorType.getDeclaredConstructor(new Class[0]);
                    returnCtor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    if (!this.hasAnnotation(ConstructorArgs.class) && log.isWarningEnabled()) {
                        log.warning("No usable constructor for " + ctorType.getName(), e);
                    }
                    break block13;
                }
            }
            ctorType = this.getType();
            if (ctorType != null) {
                try {
                    returnCtor = ctorType.getDeclaredConstructor(new Class[0]);
                    returnCtor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return returnCtor;
    }

    public String getNameToStore() {
        return this.name;
    }

    public List<String> getLoadNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.name);
        AlsoLoad al = (AlsoLoad)this.foundAnnotations.get(AlsoLoad.class);
        if (al != null && al.value() != null && al.value().length > 0) {
            names.addAll(Arrays.asList(al.value()));
        }
        return names;
    }

    public String getFirstFieldName(DBObject dbObj) {
        String fieldName = this.getNameToStore();
        boolean foundField = false;
        for (String n : this.getLoadNames()) {
            if (!dbObj.containsField(n)) continue;
            if (!foundField) {
                foundField = true;
                fieldName = n;
                continue;
            }
            throw new MappingException(String.format("Found more than one field from @AlsoLoad %s", this.getLoadNames()));
        }
        return fieldName;
    }

    public Object getDbObjectValue(DBObject dbObj) {
        return dbObj.get(this.getFirstFieldName(dbObj));
    }

    public String getJavaFieldName() {
        return this.field.getName();
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return (T)this.foundAnnotations.get(clazz);
    }

    public boolean hasAnnotation(Class ann) {
        return this.foundAnnotations.containsKey(ann);
    }

    public void addAnnotation(Class<? extends Annotation> clazz) {
        if (this.field.isAnnotationPresent(clazz)) {
            this.foundAnnotations.put(clazz, this.field.getAnnotation(clazz));
        }
    }

    public String getFullName() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    private String getMappedFieldName() {
        Serialized me;
        if (this.hasAnnotation(Id.class)) {
            return "_id";
        }
        if (this.hasAnnotation(Property.class)) {
            Property mv = (Property)this.foundAnnotations.get(Property.class);
            if (!mv.value().equals(".")) {
                return mv.value();
            }
        } else if (this.hasAnnotation(Reference.class)) {
            Reference mr = (Reference)this.foundAnnotations.get(Reference.class);
            if (!mr.value().equals(".")) {
                return mr.value();
            }
        } else if (this.hasAnnotation(Embedded.class)) {
            Embedded me2 = (Embedded)this.foundAnnotations.get(Embedded.class);
            if (!me2.value().equals(".")) {
                return me2.value();
            }
        } else if (this.hasAnnotation(Serialized.class) && !(me = (Serialized)this.foundAnnotations.get(Serialized.class)).value().equals(".")) {
            return me.value();
        }
        return this.field.getName();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name).append(" (");
        sb.append(" type:").append(this.realType.getSimpleName()).append(",");
        if (this.isSingleValue()) {
            sb.append(" single:true,");
        } else {
            sb.append(" multiple:true,");
            sb.append(" subtype:").append(this.getSubClass()).append(",");
        }
        if (this.isMap()) {
            sb.append(" map:true,");
            if (this.getMapKeyClass() != null) {
                sb.append(" map-key:").append(this.getMapKeyClass().getSimpleName());
            } else {
                sb.append(" map-key: class unknown! ");
            }
        }
        if (this.isSet()) {
            sb.append(" set:true,");
        }
        if (this.isCollection) {
            sb.append(" collection:true,");
        }
        if (this.isArray) {
            sb.append(" array:true,");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        sb.append("); ").append(this.foundAnnotations.toString());
        return sb.toString();
    }

    public Class getType() {
        return this.realType;
    }

    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Class getMapKeyClass() {
        return this.toClass(this.mapKeyType);
    }

    protected Class toClass(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof WildcardType) {
            return (Class)((WildcardType)t).getUpperBounds()[0];
        }
        throw new RuntimeException("Generic TypeVariable not supported!");
    }

    public Class getSubClass() {
        return this.toClass(this.subType);
    }

    public Type getSubType() {
        return this.subType;
    }

    public boolean isSingleValue() {
        if (!(this.isSingleValue || this.isMap || this.isSet || this.isArray || this.isCollection)) {
            throw new RuntimeException("Not single, but none of the types that are not-single.");
        }
        return this.isSingleValue;
    }

    public boolean isMultipleValues() {
        return !this.isSingleValue;
    }

    public boolean isTypeMongoCompatible() {
        return this.isMongoType;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public Constructor getCTor() {
        return this.ctor;
    }

    public Object getFieldValue(Object classInst) throws IllegalArgumentException {
        try {
            this.field.setAccessible(true);
            return this.field.get(classInst);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void setFieldValue(Object classInst, Object value) throws IllegalArgumentException {
        try {
            this.field.setAccessible(true);
            this.field.set(classInst, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public Class getConcreteType() {
        Class<?> concrete;
        Class<?> concrete2;
        Embedded e = this.getAnnotation(Embedded.class);
        if (e != null && (concrete2 = e.concreteClass()) != Object.class) {
            return concrete2;
        }
        Property p = this.getAnnotation(Property.class);
        if (p != null && (concrete = p.concreteClass()) != Object.class) {
            return concrete;
        }
        return this.getType();
    }
}

