/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.lazy.proxy;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Key;
import com.google.code.morphia.mapping.lazy.DatastoreProvider;
import com.google.code.morphia.mapping.lazy.proxy.AbstractReference;
import com.google.code.morphia.mapping.lazy.proxy.LazyReferenceFetchingException;
import com.google.code.morphia.mapping.lazy.proxy.ProxiedEntityReferenceList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableCollectionObjectReference<T>
extends AbstractReference
implements ProxiedEntityReferenceList {
    private static final long serialVersionUID = 1L;
    private ArrayList<Key<?>> listOfKeys;

    public SerializableCollectionObjectReference(Collection<T> type, Class<T> referenceObjClass, boolean ignoreMissing, DatastoreProvider p) {
        super(p, referenceObjClass, ignoreMissing);
        this.object = type;
        this.listOfKeys = new ArrayList();
    }

    @Override
    protected synchronized Object fetch() {
        Collection c = (Collection)this.object;
        c.clear();
        int numberOfEntitiesExpected = this.listOfKeys.size();
        ArrayList retrievedEntities = new ArrayList(this.listOfKeys.size());
        Datastore ds = this.p.get();
        for (Key<?> k : this.listOfKeys) {
            retrievedEntities.add(ds.getByKey(this.referenceObjClass, k));
        }
        if (!this.ignoreMissing && numberOfEntitiesExpected != retrievedEntities.size()) {
            throw new LazyReferenceFetchingException("During the lifetime of a proxy of type '" + c.getClass().getSimpleName() + "', some referenced Entities of type '" + this.referenceObjClass.getSimpleName() + "' have disappeared from the Datastore.");
        }
        c.addAll(retrievedEntities);
        return c;
    }

    @Override
    public List<Key<?>> __getKeysAsList() {
        return Collections.unmodifiableList(this.listOfKeys);
    }

    public void __add(Key key) {
        this.listOfKeys.add(key);
    }

    @Override
    public void __addAll(Collection<? extends Key<?>> keys) {
        this.listOfKeys.addAll(keys);
    }

    @Override
    protected void beforeWriteObject() {
        if (!this.__isFetched()) {
            return;
        }
        this.syncKeys();
        ((Collection)this.object).clear();
    }

    private void syncKeys() {
        Datastore ds = this.p.get();
        this.listOfKeys.clear();
        for (Object e : (Collection)this.object) {
            this.listOfKeys.add(ds.getKey(e));
        }
    }
}

