/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation.classrules;

import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.validation.ClassConstraint;
import com.google.code.morphia.mapping.validation.ConstraintViolation;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicatedAttributeNames
implements ClassConstraint {
    @Override
    public void check(MappedClass mc, Set<ConstraintViolation> ve) {
        HashSet<String> foundNames = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (MappedField mappedField : mc.getPersistenceFields()) {
            for (String name : mappedField.getLoadNames()) {
                if (foundNames.add(name)) continue;
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mappedField, this.getClass(), "Mapping to MongoDB field name '" + name + "' is duplicated; you cannot map different java fields to the same MongoDB field."));
                duplicates.add(name);
            }
        }
    }
}

