/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation.fieldrules;

import com.google.code.morphia.annotations.Serialized;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.validation.ConstraintViolation;
import com.google.code.morphia.mapping.validation.fieldrules.FieldConstraint;
import com.google.code.morphia.utils.ReflectionUtils;
import java.util.Set;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapKeyDifferentFromString
extends FieldConstraint {
    private static final String supportedExample = "(Map<String/Enum/Long/ObjectId/..., ?>)";

    @Override
    protected void check(MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.isMap() && !mf.hasAnnotation(Serialized.class)) {
            Class parameterizedClass = ReflectionUtils.getParameterizedClass(mf.getField(), 0);
            if (parameterizedClass == null) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.WARNING, mc, mf, this.getClass(), "Maps cannot be keyed by Object (Map<Object,?>); Use a parametrized type that is supported (Map<String/Enum/Long/ObjectId/..., ?>)"));
            } else if (!(parameterizedClass.equals(String.class) || parameterizedClass.equals(ObjectId.class) || ReflectionUtils.isPrimitiveLike(parameterizedClass))) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "Maps must be keyed by a simple type (Map<String/Enum/Long/ObjectId/..., ?>); " + parameterizedClass + " is not supported as a map key type."));
            }
        }
    }
}

