/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation.fieldrules;

import com.google.code.morphia.annotations.Version;
import com.google.code.morphia.mapping.DefaultCreator;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.validation.ConstraintViolation;
import com.google.code.morphia.mapping.validation.fieldrules.FieldConstraint;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionMisuse
extends FieldConstraint {
    @Override
    protected void check(MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.hasAnnotation(Version.class)) {
            Class type = mf.getType();
            if (Long.class.equals((Object)type) || Long.TYPE.equals(type)) {
                Object testInstance = DefaultCreator.createInst(mc.getClazz());
                if (Long.class.equals((Object)type)) {
                    if (mf.getFieldValue(testInstance) != null) {
                        ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "When using @" + Version.class.getSimpleName() + " on a Long field, it must be initialized to null."));
                    }
                } else if (Long.TYPE.equals(type) && (Long)mf.getFieldValue(testInstance) != 0L) {
                    ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "When using @" + Version.class.getSimpleName() + " on a long field, it must be initialized to 0."));
                }
            } else {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "@" + Version.class.getSimpleName() + " can only be used on a Long/long field."));
            }
        }
    }
}

