/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.query;

import com.google.code.morphia.query.AbstractCriteria;
import com.google.code.morphia.query.Criteria;
import com.google.code.morphia.query.CriteriaContainer;
import com.google.code.morphia.query.CriteriaJoin;
import com.google.code.morphia.query.FieldEnd;
import com.google.code.morphia.query.FieldEndImpl;
import com.google.code.morphia.query.QueryImpl;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaContainerImpl
extends AbstractCriteria
implements Criteria,
CriteriaContainer {
    private CriteriaJoin joinMethod;
    private List<Criteria> children;
    protected QueryImpl<?> query;

    protected CriteriaContainerImpl(CriteriaJoin joinMethod) {
        this.joinMethod = joinMethod;
        this.children = new ArrayList<Criteria>();
    }

    protected CriteriaContainerImpl(QueryImpl<?> query, CriteriaJoin joinMethod) {
        this(joinMethod);
        this.query = query;
    }

    @Override
    public void add(Criteria ... criteria) {
        for (Criteria c : criteria) {
            c.attach(this);
            this.children.add(c);
        }
    }

    public void remove(Criteria criteria) {
        this.children.remove(criteria);
    }

    @Override
    public void addTo(DBObject obj) {
        if (this.joinMethod == CriteriaJoin.AND) {
            for (Criteria child : this.children) {
                child.addTo(obj);
            }
        } else if (this.joinMethod == CriteriaJoin.OR) {
            BasicDBList or = new BasicDBList();
            for (Criteria child : this.children) {
                BasicDBObject container = new BasicDBObject();
                child.addTo((DBObject)container);
                or.add((Object)container);
            }
            obj.put("$or", (Object)or);
        }
    }

    @Override
    public CriteriaContainer and(Criteria ... criteria) {
        return this.collect(CriteriaJoin.AND, criteria);
    }

    @Override
    public CriteriaContainer or(Criteria ... criteria) {
        return this.collect(CriteriaJoin.OR, criteria);
    }

    private CriteriaContainer collect(CriteriaJoin cj, Criteria ... criteria) {
        CriteriaContainerImpl parent = new CriteriaContainerImpl(this.query, cj);
        for (Criteria c : criteria) {
            parent.add(c);
        }
        this.add(parent);
        return parent;
    }

    @Override
    public FieldEnd<? extends CriteriaContainer> criteria(String name) {
        return this.criteria(name, this.query.isValidatingNames());
    }

    private FieldEnd<? extends CriteriaContainer> criteria(String field, boolean validateName) {
        return new FieldEndImpl<CriteriaContainerImpl>(this.query, field, this, validateName);
    }
}

