/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.query;

import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphiaIterator<T, V>
implements Iterable<V>,
Iterator<V> {
    private final DBCursor wrapped;
    private final Mapper m;
    private final Class<T> clazz;
    private final EntityCache cache;
    private long driverTime = 0L;
    private long mapperTime = 0L;

    public MorphiaIterator(DBCursor it, Mapper m, Class<T> clazz, String kind, EntityCache cache) {
        this.wrapped = it;
        this.m = m;
        this.clazz = clazz;
        this.cache = cache;
    }

    @Override
    public Iterator<V> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.wrapped == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        boolean ret = this.wrapped.hasNext();
        this.driverTime += System.currentTimeMillis() - start;
        return ret;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BasicDBObject dbObj = this.getNext();
        return this.processItem(dbObj);
    }

    protected V processItem(BasicDBObject dbObj) {
        long start = System.currentTimeMillis();
        Object entity = this.m.fromDBObject(this.clazz, (DBObject)dbObj, this.cache);
        this.mapperTime += System.currentTimeMillis() - start;
        return (V)entity;
    }

    protected BasicDBObject getNext() {
        long start = System.currentTimeMillis();
        BasicDBObject dbObj = (BasicDBObject)this.wrapped.next();
        this.driverTime += System.currentTimeMillis() - start;
        return dbObj;
    }

    @Override
    public void remove() {
        long start = System.currentTimeMillis();
        this.wrapped.remove();
        this.driverTime += System.currentTimeMillis() - start;
    }

    public long getDriverTime() {
        return this.driverTime;
    }

    public long getMapperTime() {
        return this.mapperTime;
    }

    public void close() {
        if (this.wrapped != null) {
            this.wrapped.close();
        }
    }
}

