/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.query;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.DatastoreImpl;
import com.google.code.morphia.Key;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.google.code.morphia.query.Criteria;
import com.google.code.morphia.query.CriteriaContainerImpl;
import com.google.code.morphia.query.CriteriaJoin;
import com.google.code.morphia.query.FieldCriteria;
import com.google.code.morphia.query.FieldEnd;
import com.google.code.morphia.query.FieldEndImpl;
import com.google.code.morphia.query.FilterOperator;
import com.google.code.morphia.query.MorphiaIterator;
import com.google.code.morphia.query.MorphiaKeyIterator;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.QueryException;
import com.google.code.morphia.query.WhereCriteria;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bson.BSONObject;
import org.bson.types.CodeWScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl<T>
extends CriteriaContainerImpl
implements Query<T>,
Criteria {
    private static final Logr log = MorphiaLoggerFactory.get(QueryImpl.class);
    private EntityCache cache;
    private boolean validateName = true;
    private boolean validateType = true;
    private String[] fields = null;
    private Boolean includeFields = null;
    private DBObject sort = null;
    private DatastoreImpl ds = null;
    private DBCollection dbColl = null;
    private int offset = 0;
    private int limit = -1;
    private int batchSize = 0;
    private String indexHint;
    private Class<T> clazz = null;
    private DBObject baseQuery = null;
    private boolean snapshotted = false;
    private boolean slaveOk = false;
    private boolean noTimeout = false;

    public QueryImpl(Class<T> clazz, DBCollection coll, Datastore ds) {
        super(CriteriaJoin.AND);
        Entity entAn;
        this.query = this;
        this.clazz = clazz;
        this.ds = (DatastoreImpl)ds;
        this.dbColl = coll;
        this.cache = this.ds.getMapper().createEntityCache();
        MappedClass mc = this.ds.getMapper().getMappedClass(clazz);
        Entity entity = entAn = mc == null ? null : mc.getEntityAnnotation();
        if (entAn != null) {
            this.slaveOk = this.ds.getMapper().getMappedClass(clazz).getEntityAnnotation().slaveOk();
        }
    }

    public QueryImpl(Class<T> clazz, DBCollection coll, Datastore ds, int offset, int limit) {
        this(clazz, coll, ds);
        this.offset = offset;
        this.limit = limit;
    }

    public QueryImpl(Class<T> clazz, DBCollection coll, DatastoreImpl ds, DBObject baseQuery) {
        this(clazz, coll, ds);
        this.baseQuery = baseQuery;
    }

    @Override
    public QueryImpl<T> clone() {
        QueryImpl<T> n = new QueryImpl<T>(this.clazz, this.dbColl, this.ds);
        n.attachedTo = this.attachedTo;
        n.baseQuery = this.baseQuery;
        n.batchSize = this.batchSize;
        n.cache = this.cache;
        n.fields = this.fields;
        n.includeFields = this.includeFields;
        n.indexHint = this.indexHint;
        n.limit = this.limit;
        n.noTimeout = this.noTimeout;
        n.offset = this.offset;
        n.query = n;
        n.slaveOk = this.slaveOk;
        n.snapshotted = this.snapshotted;
        n.sort = this.sort;
        n.validateName = this.validateName;
        n.validateType = this.validateType;
        return n;
    }

    public DBCollection getCollection() {
        return this.dbColl;
    }

    public void setQueryObject(DBObject query) {
        this.baseQuery = query;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public DBObject getQueryObject() {
        BasicDBObject obj = new BasicDBObject();
        if (this.baseQuery != null) {
            obj.putAll((BSONObject)this.baseQuery);
        }
        this.addTo((DBObject)obj);
        return obj;
    }

    public DatastoreImpl getDatastore() {
        return this.ds;
    }

    public DBObject getFieldsObject() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        HashMap<String, Boolean> fieldsFilter = new HashMap<String, Boolean>();
        for (String field : this.fields) {
            fieldsFilter.put(field, this.includeFields);
        }
        return new BasicDBObject(fieldsFilter);
    }

    public DBObject getSortObject() {
        return this.sort == null ? null : this.sort;
    }

    public boolean isValidatingNames() {
        return this.validateName;
    }

    public boolean isValidatingTypes() {
        return this.validateType;
    }

    @Override
    public long countAll() {
        DBObject query = this.getQueryObject();
        if (log.isTraceEnabled()) {
            log.trace("Executing count(" + this.dbColl.getName() + ") for query: " + query);
        }
        return this.dbColl.getCount(query);
    }

    public DBCursor prepareCursor() {
        int opts;
        DBObject query = this.getQueryObject();
        DBObject fields = this.getFieldsObject();
        if (log.isTraceEnabled()) {
            log.trace("Running query(" + this.dbColl.getName() + ") : " + query + ", fields:" + fields + ",off:" + this.offset + ",limit:" + this.limit);
        }
        DBCursor cursor = this.dbColl.find(query, fields);
        if (this.offset > 0) {
            cursor.skip(this.offset);
        }
        if (this.limit > 0) {
            cursor.limit(this.limit);
        }
        if (this.batchSize > 0) {
            cursor.batchSize(this.batchSize);
        }
        if (this.snapshotted) {
            cursor.snapshot();
        }
        if (this.sort != null) {
            cursor.sort(this.sort);
        }
        if (this.indexHint != null) {
            cursor.hint(this.indexHint);
        }
        if (this.slaveOk) {
            opts = this.dbColl.getOptions();
            cursor.addOption(opts |= 4);
        }
        if (this.noTimeout) {
            opts = this.dbColl.getOptions();
            cursor.addOption(opts |= 0x10);
        }
        if (this.snapshotted && (this.sort != null || this.indexHint != null)) {
            log.warning("Snapshotted query should not have hint/sort.");
        }
        return cursor;
    }

    @Override
    public Iterable<T> fetch() {
        DBCursor cursor = this.prepareCursor();
        if (log.isTraceEnabled()) {
            log.trace("Getting cursor(" + this.dbColl.getName() + ")  for query:" + cursor.getQuery());
        }
        return new MorphiaIterator(cursor, this.ds.getMapper(), this.clazz, this.dbColl.getName(), this.cache);
    }

    @Override
    public Iterable<Key<T>> fetchKeys() {
        String[] oldFields = this.fields;
        Boolean oldInclude = this.includeFields;
        this.fields = new String[]{"_id"};
        this.includeFields = true;
        DBCursor cursor = this.prepareCursor();
        if (log.isTraceEnabled()) {
            log.trace("Getting cursor(" + this.dbColl.getName() + ") for query:" + cursor.getQuery());
        }
        this.fields = oldFields;
        this.includeFields = oldInclude;
        return new MorphiaKeyIterator<T>((Iterator)cursor, this.ds.getMapper(), this.clazz, this.dbColl.getName());
    }

    @Override
    public List<T> asList() {
        ArrayList results = new ArrayList();
        MorphiaIterator iter = (MorphiaIterator)this.fetch().iterator();
        for (Object ent : iter) {
            results.add(ent);
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("\nasList: %s \t %d entities, iterator time: driver %n ms, mapper %n ms \n cache: %s \n for $s \n ", this.dbColl.getName(), results.size(), iter.getDriverTime(), iter.getMapperTime(), this.cache.stats().toString(), this.getQueryObject()));
        }
        return results;
    }

    @Override
    public List<Key<T>> asKeyList() {
        ArrayList<Key<T>> results = new ArrayList<Key<T>>();
        for (Key<T> key : this.fetchKeys()) {
            results.add(key);
        }
        return results;
    }

    @Override
    public Iterable<T> fetchEmptyEntities() {
        String[] oldFields = this.fields;
        Boolean oldInclude = this.includeFields;
        this.fields = new String[]{"_id"};
        this.includeFields = true;
        Iterable<T> res = this.fetch();
        this.fields = oldFields;
        this.includeFields = oldInclude;
        return res;
    }

    protected FilterOperator translate(String operator) {
        if ((operator = operator.trim()).equals("=") || operator.equals("==")) {
            return FilterOperator.EQUAL;
        }
        if (operator.equals(">")) {
            return FilterOperator.GREATER_THAN;
        }
        if (operator.equals(">=")) {
            return FilterOperator.GREATER_THAN_OR_EQUAL;
        }
        if (operator.equals("<")) {
            return FilterOperator.LESS_THAN;
        }
        if (operator.equals("<=")) {
            return FilterOperator.LESS_THAN_OR_EQUAL;
        }
        if (operator.equals("!=") || operator.equals("<>")) {
            return FilterOperator.NOT_EQUAL;
        }
        if (operator.toLowerCase().equals("in")) {
            return FilterOperator.IN;
        }
        if (operator.toLowerCase().equals("nin")) {
            return FilterOperator.NOT_IN;
        }
        if (operator.toLowerCase().equals("all")) {
            return FilterOperator.ALL;
        }
        if (operator.toLowerCase().equals("exists")) {
            return FilterOperator.EXISTS;
        }
        if (operator.toLowerCase().equals("elem")) {
            return FilterOperator.ELEMENT_MATCH;
        }
        if (operator.toLowerCase().equals("size")) {
            return FilterOperator.SIZE;
        }
        if (operator.toLowerCase().equals("within")) {
            return FilterOperator.WITHIN;
        }
        if (operator.toLowerCase().equals("near")) {
            return FilterOperator.NEAR;
        }
        throw new IllegalArgumentException("Unknown operator '" + operator + "'");
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 6) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        String prop = parts[0].trim();
        FilterOperator op = parts.length == 2 ? this.translate(parts[1]) : FilterOperator.EQUAL;
        this.add(new FieldCriteria(this, prop, op, value, this.validateName, this.validateType));
        return this;
    }

    @Override
    public Query<T> where(CodeWScope js) {
        this.add(new WhereCriteria(js));
        return this;
    }

    @Override
    public Query<T> where(String js) {
        this.add(new WhereCriteria(js));
        return this;
    }

    @Override
    public Query<T> enableValidation() {
        this.validateType = true;
        this.validateName = true;
        return this;
    }

    @Override
    public Query<T> disableValidation() {
        this.validateType = false;
        this.validateName = false;
        return this;
    }

    QueryImpl<T> validateNames() {
        this.validateName = true;
        return this;
    }

    QueryImpl<T> disableTypeValidation() {
        this.validateType = false;
        return this;
    }

    @Override
    public T get() {
        int oldLimit = this.limit;
        this.limit = 1;
        Iterator<T> it = this.fetch().iterator();
        this.limit = oldLimit;
        return it.hasNext() ? (T)it.next() : null;
    }

    @Override
    public Key<T> getKey() {
        int oldLimit = this.limit;
        this.limit = 1;
        Iterator<Key<T>> it = this.fetchKeys().iterator();
        this.limit = oldLimit;
        return it.hasNext() ? it.next() : null;
    }

    @Override
    public Query<T> limit(int value) {
        this.limit = value;
        return this;
    }

    @Override
    public Query<T> batchSize(int value) {
        this.batchSize = value;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Query<T> skip(int value) {
        this.offset = value;
        return this;
    }

    @Override
    public Query<T> offset(int value) {
        this.offset = value;
        return this;
    }

    @Override
    public Query<T> order(String condition) {
        if (this.snapshotted) {
            throw new QueryException("order cannot be used on a snapshotted query.");
        }
        this.sort = QueryImpl.parseSortString(condition);
        return this;
    }

    public static BasicDBObject parseSortString(String str) {
        String[] parts;
        BasicDBObjectBuilder ret = BasicDBObjectBuilder.start();
        for (String s : parts = str.split(",")) {
            s = s.trim();
            int dir = 1;
            if (s.startsWith("-")) {
                dir = -1;
                s = s.substring(1).trim();
            }
            ret = ret.add(s, (Object)dir);
        }
        return (BasicDBObject)ret.get();
    }

    @Override
    public Iterator<T> iterator() {
        return this.fetch().iterator();
    }

    @Override
    public Class<T> getEntityClass() {
        return this.clazz;
    }

    @Override
    public String toString() {
        return this.getQueryObject().toString();
    }

    @Override
    public FieldEnd<? extends Query<T>> field(String name) {
        return this.field(name, this.validateName);
    }

    private FieldEnd<? extends Query<T>> field(String field, boolean validate) {
        return new FieldEndImpl<QueryImpl>(this, field, this, validate);
    }

    @Override
    public FieldEnd<? extends CriteriaContainerImpl> criteria(String field) {
        return this.criteria(field, this.validateName);
    }

    private FieldEnd<? extends CriteriaContainerImpl> criteria(String field, boolean validate) {
        CriteriaContainerImpl container = new CriteriaContainerImpl(this, CriteriaJoin.AND);
        this.add(container);
        return new FieldEndImpl<CriteriaContainerImpl>(this, field, container, validate);
    }

    @Override
    public Query<T> hintIndex(String idxName) {
        this.indexHint = idxName;
        return this;
    }

    @Override
    public Query<T> retrievedFields(boolean include, String ... fields) {
        if (this.includeFields != null && include != this.includeFields) {
            throw new IllegalStateException("You cannot mix include and excluded fields together!");
        }
        this.includeFields = include;
        this.fields = fields;
        return this;
    }

    @Override
    public Query<T> enableSnapshotMode() {
        this.snapshotted = true;
        return this;
    }

    @Override
    public Query<T> disableSnapshotMode() {
        this.snapshotted = false;
        return this;
    }

    @Override
    public Query<T> queryNonPrimary() {
        this.slaveOk = true;
        return this;
    }

    @Override
    public Query<T> queryPrimaryOnly() {
        this.slaveOk = false;
        return this;
    }

    @Override
    public Query<T> disableTimeout() {
        this.noTimeout = false;
        return this;
    }

    @Override
    public Query<T> enableTimeout() {
        this.noTimeout = true;
        return this;
    }
}

