#import "Sprite.h"

@implementation Sprite
@synthesize pic;

- (id) initWithImage: (NSString*) imageName
           addToView: (UIView*) parentView {
  if (self == [super init]) {
    UIImage* img = [UIImage imageNamed:imageName];
    
    pic = [[UIImageView alloc] initWithImage:img];
    [self addSubview:pic];
    [parentView addSubview:self];
    width = img.size.width;
    height = img.size.height;
  }
  return self;
}

- (void) x: (double) x
         y: (double) y
     scale: (double) faktor {
  scale = faktor;
   pic.frame = CGRectMake(x, y, width*faktor, height*faktor);
}

- (void) flipX: (BOOL) x
         flipY: (BOOL) y {
  pic.transform = CGAffineTransformMakeScale((x?-1:1),(y?-1:1));
}

- (CGPoint) position {return CGPointMake(pic.frame.origin.x,pic.frame.origin.y);}
- (double) width {return width;}
- (double) height {return height;}
- (double) scale {return scale;}
- (CGRect) frame {return CGRectMake(pic.frame.origin.x, pic.frame.origin.y, width*scale, height*scale);}

@end
