#import <UIKit/UIKit.h>
#import "Sprite.h"

@interface ViewController : UIViewController {
  // Generell:
  UIImageView *canvas;  // Gamescreen
  double z;             // Animationszaehler
  double screenWidth;   // Displaybreite
  double screenHeight;  // Displayhoehe
 
  // Ninja
  Sprite *player;       // Ninja-Hauptsprite
  NSMutableArray *foot; // beide Fusssprites
  BOOL ninjaJumps;      // springt?
  double playerX;       // x-Koordinate
  double playerY;       // y-Koordinate
  double speed;         // Bewegung in x-Richtung (laufen)
  double gravity;       // Bewegung in y-Richtung (fallen/springen)

  // andere Sprites
  NSMutableArray *platforms;
  NSMutableArray *bush;
  Sprite *star;

  // Head-Up-Display (HUD)
  Sprite *energyIcon;
  UIView *energyBar;
  UIView *energyBarBg;
  UILabel *score;
  double energy;    // Energie
  int distance;     // Fortschrittsanzeige
}

@property (nonatomic,strong) UIImageView *canvas;
@property (nonatomic,strong) Sprite *player;
@property (nonatomic,strong) Sprite *star;
@property (nonatomic,strong) Sprite *energyIcon;
@property (nonatomic,strong) UIView *energyBar;
@property (nonatomic,strong) UIView *energyBarBg;
@property (nonatomic,strong) UILabel *score;
@property (nonatomic, strong) NSMutableArray *platforms;
@property (nonatomic, strong) NSMutableArray *bush;
@property (nonatomic, strong) NSMutableArray *foot;

-(void)newGame;
-(void)gameEngine;
-(void)renderHeadUpDisplay;
-(void)renderBushs;
-(void)renderPlatforms;
-(void)checkIfNinjaIsOnPlatform;
-(void)renderStar;
-(void)checkIfNinjaTouchesStar;
-(void)renderNinja;

@end
