#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QFileDialog>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <math.h>
#include "gui.h"

Gui::Gui(QWidget *parent) : QWidget(parent) {

  int i;

  data = new Data(this);
  QVBoxLayout *guiLayout = new QVBoxLayout;
  setLayout(guiLayout);
  waveWidget = new WaveWidget(data, this);
  guiLayout->addWidget(waveWidget);
  QWidget *labelFrame = new QWidget;
  QHBoxLayout *labelLayout = new QHBoxLayout;
  labelFrame->setLayout(labelLayout);
  guiLayout->addWidget(labelFrame);
  statusLabel = new QLabel("Status: Standby");
  labelLayout->addWidget(statusLabel);
  for (i = 0; i < 2; i++) {
    dbLabel[i] = new QLabel;
    labelLayout->addWidget(dbLabel[i]);
    max[i] = 0;
  }  
  QWidget *buttonFrame = new QWidget;
  QHBoxLayout *buttonLayout = new QHBoxLayout;
  buttonFrame->setLayout(buttonLayout);
  guiLayout->addWidget(buttonFrame);
  QPushButton *startButton = new QPushButton("Start");
  buttonLayout->addWidget(startButton);
  QObject::connect(startButton, SIGNAL(clicked()), this, SLOT(startRec()));
  QPushButton *stopButton = new QPushButton("Stop");
  buttonLayout->addWidget(stopButton);
  QObject::connect(stopButton, SIGNAL(clicked()), this, SLOT(stopRec()));
  JackProcessor *jackProcessor = new JackProcessor(data);
  jackProcessor->initJack();
  QObject::connect(jackProcessor, SIGNAL(chunkReady()), waveWidget, SLOT(getChunk()));
  QObject::connect(jackProcessor, SIGNAL(chunkReady()), this, SLOT(updateDB()));
  wavRecorder = new WavRecorder(data);
  maxCounter = 0;
  guiLayout->setStretchFactor(waveWidget, 10);
}

Gui::~Gui() {

  data->setRecord(false);
  wavRecorder->wait();
  data->stopJack();
}

void Gui::startRec() {

  if (!wavRecorder->isRunning()) {
    QString qs = QFileDialog::getSaveFileName(this, "Speichern unter");
    if (!qs.isEmpty()) {
      data->setSavePath(qs);
      data->setRecord(true);
      statusLabel->setText("Status: Aufnahme");
      wavRecorder->start();
    }  
  }  
}

void Gui::stopRec() {

  data->setRecord(false);
  statusLabel->setText("Status: Standby");
  wavRecorder->wait();
}

void Gui::updateDB() {

  int i;
  QStringList labels;
  
  for(i = 0; i < 2; i++) {
    if (max[i] < fabs(data->limits[2 * i])) max[i] = fabs(data->limits[2 * i]);
    if (max[i] < data->limits[2 * i + 1]) max[i] = data->limits[2 * i + 1];
  }
  if (maxCounter++ >= (double)data->getRate() / (double)data->getJackBufSize()) {
    labels << "Links: " << "Rechts: ";
    maxCounter = 0;
    for(i = 0; i < 2; i++) 
      if (max[i] > 0) {
        dbLabel[i]->setText(labels.at(i) + QString::number(20.0 * log10(max[i]), 'f', 1) + " dB");
        max[i] = 0;
      } 
  }
}
