#ifndef GUI_H
#define GUI_H

#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include "data.h"
#include "jackprocessor.h"
#include "wavrecorder.h"
#include "wavewidget.h"

class Gui : public QWidget
{
  Q_OBJECT

  private:
    Data *data; 
    JackProcessor *jackProcessor;
    WavRecorder *wavRecorder;
    WaveWidget *waveWidget;
    QLabel *statusLabel, *dbLabel[2];
    double max[2];
    int maxCounter;
    
  public:
    Gui(QWidget* parent=0);
    ~Gui();

  public slots: 
    void startRec();
    void stopRec();
    void updateDB();
};

#endif
