#include <QtGui/QWidget>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QPainter>
#include <QtGui/QColor>
#include <QtGui/QResizeEvent>
#include <QtCore/QString>
#include "data.h"
#include "wavewidget.h"

WaveWidget::WaveWidget(Data *p_data, QWidget *parent) : QWidget(parent) {

  int i;

  data = p_data;
  setMinimumSize(WAVE_WIDTH, WAVE_HEIGHT);
  setPalette(QPalette(QColor(200, 200, 200), QColor(20, 0, 70)));
  setAutoFillBackground(true);
  for (i = 0; i < 4; i++) {
    wave[i] = (double *)malloc(width() * sizeof(double));
    memset(wave[i], 0, width() * sizeof(double));   
  }
  waveOfs = 0;
  waveCounter = 0;
}

WaveWidget::~WaveWidget() {
  
}

void WaveWidget::paintEvent(QPaintEvent *) {

  QPainter p;
  int i, w, h, l;
  double yScale;

  w = width();
  h = height();
  yScale = h / 4.0;
  l = h >> 1;
  p.begin(this);
  p.setPen(QPen(QBrush(QColor(170, 120, 0)), 1));
  p.drawLine(0, (int)(0.5 * (double)l), w - 1, (int)(0.5 * (double)l));
  p.drawLine(0, (int)(1.5 * (double)l), w - 1, (int)(1.5 * (double)l));
  for (i=0; i < w; i++) {
    p.drawLine(i, (int)(0.5 * (double)l - yScale * wave[0][(waveOfs + i) % w]), i, (int)(0.5 * (double)l - yScale * wave[1][(waveOfs + i) % w]));
    p.drawLine(i, (int)(1.5 * (double)l - yScale * wave[2][(waveOfs + i) % w]), i, (int)(1.5 * (double)l - yScale * wave[3][(waveOfs + i) % w]));
  }
  p.end();
}

void WaveWidget::resizeEvent(QResizeEvent *ev) {

  int i1, i2, w, old_w;

  w = width();
  old_w = ev->oldSize().width();
  for (i1 = 0; i1 < 4; i1++) {
    wave[i1] = (double *)realloc(wave[i1], w * sizeof(double));
    if (old_w > 0) 
      for (i2 = old_w; i2 < w; i2++) 
        wave[i1][i2] = 0;
  }
  waveOfs = 0;
  QWidget::resizeEvent(ev);
}

void WaveWidget::getChunk() {

  int i;
  
  for (i = 0; i < 4; i++) 
    wave[i][waveOfs] = data->limits[i];
  waveOfs++;
  if (waveOfs >= width()) waveOfs = 0;
  if (waveCounter++ >= (double)data->getRate() / (FRAME_RATE * (double)data->getJackBufSize())) {
    waveCounter = 0;
    repaint();
  }  
}
