#include <QtGui/QVBoxLayout>
#include <QtGui/QTextEdit>
#include <QtCore/QString>
#include "gui.h"

Gui::Gui(QWidget *parent) : QWidget(parent) {

  QVBoxLayout *guiLayout = new QVBoxLayout;
  setLayout(guiLayout);
  textEdit = new QTextEdit;
  textEdit->setReadOnly(true);
  guiLayout->addWidget(textEdit);
  JackProcessor *jackProcessor = new JackProcessor(this);
  jackProcessor->initJack();
  QObject::connect(jackProcessor, SIGNAL(midiEvent(int, int, int, int)), this, SLOT(processMidi(int, int, int, int)));
}

void Gui::processMidi(int type, int ch, int index, int val) {

  QString qs;

  qs = "Channel: " + QString::number(ch + 1);
  switch (type) {
  case 0x80:
    qs += " Note Off " + QString::number(index) + ": " + QString::number(val);
    break;
  case 0x90: 
    qs += " Note On " + QString::number(index) + ": " + QString::number(val);
    break;
  case 0xB0:
    qs += " Controller " + QString::number(index) + ": " + QString::number(val);
    break;
  case 0xC0:
    qs += " Program: " + QString::number(index);
    break;
  case 0xD0:
    qs += " Aftertouch: " + QString::number(index);
    break;
  case 0xE0:
    qs += " Pitchbend: " + QString::number(index + (val<<7) - 8192);
    break;
  }
  textEdit->insertPlainText(qs + "\n");
  textEdit->ensureCursorVisible();  
}
