#ifndef GUI_H
#define GUI_H

#include <QtGui/QWidget>
#include <QtGui/QSlider>
#include <QtGui/QLabel>
#include "data.h"
#include "colordialog.h"
#include "iterationdialog.h"
#include "mandelview.h"
#include "mandelcalc.h"
#include "juliaview.h"
#include "juliacalc.h"
#include "hiresdialog.h"
#include "hiresview.h"
#include "hirescalc.h"

class Gui : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    ColorDialog *colorDialog;
    IterationDialog *iterationDialog;
    HiresDialog *hiresDialog;
    MandelView *mandelView;
    JuliaView *juliaView;
    MandelCalc **mandelCalc;
    JuliaCalc **juliaCalc;
    HiresCalc **hiresCalc;
    QSlider *mandelZoomSlider, *juliaZoomSlider;
    QLabel *mandelLabel[6], *juliaLabel[8];

  public:
    Gui(QWidget* parent=0);
    ~Gui();
    void loadPalette(int index, QFile *f);
    void savePalette(int index, QFile *f);

  signals:
    void refreshHiresView();
 
  public slots: 
    void mandelZoomMoved(int value);
    void setMandelZoom(int value);
    void juliaZoomMoved(int value);
    void setJuliaZoom(int value);
    void moveMandel(QPoint dp);
    void updateMandel();
    void updateMandelPalette();
    void mandelCalcFinished();
    void moveJulia(QPoint dp);
    void updateJulia();
    void updateJuliaPalette();
    void juliaCalcFinished();
    void updateImage(int index);
    void updateNormalization();
    void showColorDialog();
    void showIterationDialog();
    void showHiRes();
    void refreshHires();
    void hiresCalcFinished();
    void loadMandelPalette();
    void saveMandelPalette();
    void loadJuliaPalette();
    void saveJuliaPalette();
    void saveMandel();
    void saveJulia();
    void saveHiRes();
    void loadState();
    void saveState();
};

#endif
