#ifndef HIRESDIALOG_H
#define HIRESDIALOG_H

#include <stdio.h>
#include <stdlib.h>
#include <QtGui/QWidget>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QScrollArea>
#include <QtGui/QSpinBox>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QComboBox>
#include <QtCore/QTimer>
#include "data.h"
#include "hiresview.h"

class HiresDialog : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    int hiresWidth, hiresHeight;
    QScrollArea *scroll;
    QPushButton *closeButton, *refreshButton;
    QSpinBox *resolutionSpin[2];
    QComboBox *fractalSelector;
    HiresView *hiresView;
    QLabel *statusLabel;
    QTimer *timer;
    int sx, sy;

  public:
    HiresDialog(Data *p_data, QWidget* parent=0, Qt::WindowFlags f=0);
    ~HiresDialog();

  signals:
    void resolutionChanged();
    void refreshHires();

  public slots: 
    void setWidth(int value);
    void setHeight(int value);
    void setFractal(int value);
    void refreshClicked();
    void refreshHiresView();
    void updateStatus();
    void moveHiresView(QPoint dp);
};

#endif
