#ifndef JULIAVIEW_H
#define JULIAVIEW_H

#include <math.h>
#include <QtGui/QWidget>
#include <QtGui/QMouseEvent>
#include <QtCore/QString>
#include <QtCore/QPoint>
#include "data.h"

class JuliaView : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    QPoint mousePos;
    bool mousePressed;
    int *juliaDataCache;

  public:
    JuliaView(Data *p_data, QWidget* parent=0, int w=300, int h=200);
    ~JuliaView();

  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void mousePressEvent (QMouseEvent* );
    virtual void mouseReleaseEvent (QMouseEvent* );
    virtual void mouseMoveEvent (QMouseEvent* );
    virtual void mouseDoubleClickEvent (QMouseEvent *ev);

  signals:
    void imageMoved(QPoint dp);

  public slots: 
    void moveImage (QPoint dp);
    void changeColor();
};
  
#endif
