#include <math.h>
#include <QtCore/QObject>
#include "data.h"
#include "mandelcalc.h"

MandelCalc::MandelCalc(Data *p_data, int p_id, QThread *parent) : QThread(parent) {

  data = p_data;
  id = p_id;
}

MandelCalc::~MandelCalc() {

}

int MandelCalc::mandelPixel(long double c_re, long double c_im, long double max) {

  int iteration;
  long double z_re1, z_re2, z_im1, z_im2, b;
  
  z_re1 = 0;
  z_im1 = 0;
  z_re2 = 0;
  z_im2 = 0;
  b = 0;
  iteration = 0;
  while ((b < max) && (iteration < data->getMaxIterations(0))) {
    z_re2 = z_re1 * z_re1 - z_im1 * z_im1 + c_re;
    z_im2 = 2.0 * z_re1 * z_im1 + c_im;
    b = z_re2 * z_re2 + z_im2 * z_im2;
    z_re1 = z_re2;
    z_im1 = z_im2;
    iteration++;
  }   
  return(iteration);
}

void MandelCalc::run() {

  int pixel, refPixel;
  int xOfs, yOfs;
  QPoint tile;
  int i1, i2, d, s, w;
  bool isConstant, fillMode;
  long double c_re, c_im, max;
  long double xScale, yScale, pScale;
  QRgb colorPixel;

  data->getOfs(0, xOfs, yOfs);
  data->getScale(0, xScale, yScale);
  max = data->getMaxAbsoluteValue(0);
  while (data->getNextTile(0, tile) && !data->shutdownFlag) {
    fillMode = false;
    for (d = TILE_LEN; d > 0; d--) {
      isConstant = true;
      refPixel = mandelPixel((long double)(tile.x() + xOfs) * xScale, 
                             (long double)(tile.y() + yOfs) * yScale, max);
      for (s = 0; s < d; s++) {
        c_re = (long double)(s + tile.x() + xOfs) * xScale;
        c_im = (long double)(tile.y() + yOfs) * yScale;
        pixel = (fillMode) ? refPixel : mandelPixel(c_re, c_im, max);
        if (pixel != refPixel) {
          isConstant = false;
        }  
        tileBuf[s][s] = pixel;
        c_re = (long double)(s + tile.x() + xOfs) * xScale;
        c_im = (long double)(d - 1 + tile.y() + yOfs) * yScale;
        pixel = (fillMode) ? refPixel : mandelPixel(c_re, c_im, max);
        if (pixel != refPixel) {
          isConstant = false;
        }  
        tileBuf[s][d-1] = pixel;
        c_re = (long double)(tile.x() + xOfs) * xScale;
        c_im = (long double)(s + tile.y() + yOfs) * yScale;
        pixel = (fillMode) ? refPixel : mandelPixel(c_re, c_im, max);
        if (pixel != refPixel) {
          isConstant = false;
        }  
        tileBuf[0][s] = pixel;
        c_re = (long double)(d - 1 + tile.x() + xOfs) * xScale;
        c_im = (long double)(s + tile.y() + yOfs) * yScale;
        pixel = (fillMode) ? refPixel : mandelPixel(c_re, c_im, max);
        if (pixel != refPixel) {
          isConstant = false;
        }  
        tileBuf[d-1][s] = pixel;          
      }
      fillMode = isConstant;
    }
    data->mandelMutex.lock();
    w = data->getImageWidth();
    pScale = (data->getNormalize()) ? (long double)data->getMaxIterations(0) / (long double)data->getMax(0) : 1.0;
    for (i1 = 0; i1 < TILE_LEN; i1++) {
      for (i2 = 0; i2 < TILE_LEN; i2++) {
        data->mandelData[(i1 + tile.x())  + (i2 + tile.y()) * w] = tileBuf[i1][i2]; 
        colorPixel = data->getPalette(0, (int)(pScale * (long double)tileBuf[i1][i2])).rgb();
        data->mandelImage->setPixel(i1 + tile.x(), i2 + tile.y(), colorPixel);
      }  
    }
    data->mandelMutex.unlock();
  }    
}
